/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class PipelineBlockWithTests
implements Serializable {
    private final String blockId;
    private final Map<String, PipelineBlockWithTests> childBlocks = new TreeMap<String, PipelineBlockWithTests>();
    private final Set<String> leafNodes = new TreeSet<String>();
    private static final long serialVersionUID = 1L;

    public PipelineBlockWithTests(@Nonnull String blockId) {
        this.blockId = blockId;
    }

    @Nonnull
    public String getBlockId() {
        return this.blockId;
    }

    @Nonnull
    public Map<String, PipelineBlockWithTests> getChildBlocks() {
        return this.childBlocks;
    }

    @Nonnull
    public Set<String> getLeafNodes() {
        return this.leafNodes;
    }

    public void addChildBlock(@Nonnull PipelineBlockWithTests child) {
        this.childBlocks.put(child.getBlockId(), child);
    }

    public void addLeafNode(@Nonnull String leafNode) {
        this.leafNodes.add(leafNode);
    }

    public void merge(@Nonnull PipelineBlockWithTests toMerge) {
        if (toMerge.getBlockId().equals(this.blockId) && !this.equals(toMerge)) {
            for (String childId : toMerge.getChildBlocks().keySet()) {
                if (!this.childBlocks.containsKey(childId)) {
                    this.childBlocks.put(childId, toMerge.getChildBlocks().get(childId));
                    continue;
                }
                this.childBlocks.get(childId).merge(toMerge.getChildBlocks().get(childId));
            }
            this.leafNodes.addAll(toMerge.getLeafNodes());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineBlockWithTests that = (PipelineBlockWithTests)o;
        return that.getBlockId().equals(this.getBlockId()) && that.getChildBlocks().equals(this.getChildBlocks()) && that.getLeafNodes().equals(this.getLeafNodes());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getBlockId().hashCode();
        result = 31 * result + this.getChildBlocks().hashCode();
        result = 31 * result + this.getLeafNodes().hashCode();
        return result;
    }

    @Nonnull
    public Set<String> nodesWithTests() {
        TreeSet<String> nodes = new TreeSet<String>();
        nodes.addAll(this.leafNodes);
        for (PipelineBlockWithTests child : this.childBlocks.values()) {
            nodes.addAll(child.nodesWithTests());
        }
        return nodes;
    }
}

