/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.Palette;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.tasks.junit.TrendTestResultSummary;
import hudson.tasks.test.TestObjectTrendSeriesBuilder;
import hudson.tasks.test.TestResultTrendSeriesBuilder;
import java.util.List;

public class TestResultTrendChart {
    public LinesChartModel create(List<TrendTestResultSummary> results) {
        LinesDataSet dataset = new LinesDataSet();
        results.forEach(result -> dataset.add(result.getDisplayName(), result.toMap(), result.getBuildNumber()));
        return this.getLinesChartModel(dataset);
    }

    public LinesChartModel create(@NonNull Iterable results, ChartModelConfiguration configuration) {
        TestResultTrendSeriesBuilder builder = new TestResultTrendSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        return this.getLinesChartModel(dataSet);
    }

    public LinesChartModel createFromTestObject(Iterable results, ChartModelConfiguration configuration) {
        TestObjectTrendSeriesBuilder builder = new TestObjectTrendSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        return this.getLinesChartModel(dataSet);
    }

    private LinesChartModel getLinesChartModel(LinesDataSet dataSet) {
        LinesChartModel model = new LinesChartModel();
        model.setDomainAxisLabels(dataSet.getDomainAxisLabels());
        model.setBuildNumbers(dataSet.getBuildNumbers());
        LineSeries failed = new LineSeries("Failed", Palette.RED.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        failed.addAll(dataSet.getSeries("failed"));
        model.addSeries(new LineSeries[]{failed});
        LineSeries skipped = new LineSeries("Skipped", Palette.GRAY.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        skipped.addAll(dataSet.getSeries("skipped"));
        model.addSeries(new LineSeries[]{skipped});
        LineSeries passed = new LineSeries("Passed", Palette.BLUE.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        passed.addAll(dataSet.getSeries("passed"));
        model.addSeries(new LineSeries[]{passed});
        return model;
    }
}

