/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.HistoryTestResultSummary;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestObjectIterable;
import hudson.tasks.test.TestResultDurationChart;
import hudson.tasks.test.TestResultTrendChart;
import hudson.util.RunList;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Restricted(value={NoExternalUse.class})
public class History {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private static final String EMPTY_CONFIGURATION = "{}";
    private final hudson.tasks.test.TestObject testObject;

    public History(hudson.tasks.test.TestObject testObject) {
        this.testObject = testObject;
    }

    public hudson.tasks.test.TestObject getTestObject() {
        return this.testObject;
    }

    public boolean historyAvailable() {
        TestResultImpl pluggableStorage;
        if (this.testObject instanceof TestResult && (pluggableStorage = ((TestResult)this.testObject).getPluggableStorage()) != null) {
            return pluggableStorage.getCountOfBuildsWithTestResults() > 1;
        }
        return this.testObject.getRun().getParent().getBuilds().size() > 1;
    }

    @JavaScriptMethod
    public String getTestResultTrend(String configuration) {
        return JACKSON_FACADE.toJson((Object)this.createTestResultTrend(ChartModelConfiguration.fromJson((String)configuration)));
    }

    private LinesChartModel createTestResultTrend(ChartModelConfiguration chartModelConfiguration) {
        TestResultImpl pluggableStorage = this.getPluggableStorage();
        if (pluggableStorage != null) {
            return new TestResultTrendChart().create(pluggableStorage.getTrendTestResultSummary());
        }
        return new TestResultTrendChart().createFromTestObject(this.createBuildHistory(this.testObject), chartModelConfiguration);
    }

    @JavaScriptMethod
    public String getTestDurationTrend(String configuration) {
        return JACKSON_FACADE.toJson((Object)this.createTestDurationResultTrend(ChartModelConfiguration.fromJson((String)configuration)));
    }

    private LinesChartModel createTestDurationResultTrend(ChartModelConfiguration chartModelConfiguration) {
        TestResultImpl pluggableStorage = this.getPluggableStorage();
        if (pluggableStorage != null) {
            return new TestResultDurationChart().create(pluggableStorage.getTestDurationResultSummary());
        }
        return new TestResultDurationChart().create(this.createBuildHistory(this.testObject), chartModelConfiguration);
    }

    private TestObjectIterable createBuildHistory(hudson.tasks.test.TestObject testObject) {
        return new TestObjectIterable(testObject);
    }

    private TestResultImpl getPluggableStorage() {
        TestResultImpl pluggableStorage = null;
        if (this.testObject instanceof TestResult) {
            pluggableStorage = ((TestResult)this.testObject).getPluggableStorage();
        } else if (this.testObject instanceof PackageResult) {
            pluggableStorage = ((PackageResult)this.testObject).getParent().getPluggableStorage();
        } else if (this.testObject instanceof ClassResult) {
            pluggableStorage = ((ClassResult)this.testObject).getParent().getParent().getPluggableStorage();
        } else if (this.testObject instanceof CaseResult) {
            pluggableStorage = ((CaseResult)this.testObject).getParent().getParent().getParent().getPluggableStorage();
        }
        return pluggableStorage;
    }

    public HistoryTableResult retrieveHistorySummary(int userOffset) {
        TestResultImpl pluggableStorage;
        int offset = userOffset;
        if (userOffset > 1000 || userOffset < 0) {
            offset = 0;
        }
        if ((pluggableStorage = this.getPluggableStorage()) != null) {
            return new HistoryTableResult(pluggableStorage.getHistorySummary(offset));
        }
        return new HistoryTableResult(this.getHistoryFromFileStorage());
    }

    private List<HistoryTestResultSummary> getHistoryFromFileStorage() {
        hudson.tasks.test.TestObject testObject = this.getTestObject();
        RunList builds = testObject.getRun().getParent().getBuilds();
        return builds.stream().map(build -> {
            TestObject resultInRun = testObject.getResultInRun((Run)build);
            if (resultInRun == null) {
                return null;
            }
            return new HistoryTestResultSummary((Run<?, ?>)build, ((hudson.tasks.test.TestResult)resultInRun).getDuration(), ((hudson.tasks.test.TestResult)resultInRun).getFailCount(), ((hudson.tasks.test.TestResult)resultInRun).getSkipCount(), ((hudson.tasks.test.TestResult)resultInRun).getPassCount(), ((hudson.tasks.test.TestObject)resultInRun).getDescription());
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static int asInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static class HistoryTableResult {
        private boolean descriptionAvailable;
        private List<HistoryTestResultSummary> historySummaries;

        public HistoryTableResult(List<HistoryTestResultSummary> historySummaries) {
            this.descriptionAvailable = historySummaries.stream().anyMatch(summary -> summary.getDescription() != null);
            this.historySummaries = historySummaries;
        }

        public boolean isDescriptionAvailable() {
            return this.descriptionAvailable;
        }

        public List<HistoryTestResultSummary> getHistorySummaries() {
            return this.historySummaries;
        }
    }
}

