/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.test.PipelineTestDetails;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.junit.checks.JUnitChecksPublisher;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JUnitResultArchiver
extends Recorder
implements SimpleBuildStep,
JUnitTask {
    private static final Logger LOGGER = Logger.getLogger(JUnitResultArchiver.class.getName());
    private final String testResults;
    private String stdioRetention;
    private boolean keepProperties;
    private DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;
    private Double healthScaleFactor;
    private boolean allowEmptyResults;
    private boolean skipPublishingChecks;
    private String checksName;
    private boolean skipMarkingBuildUnstable;
    private boolean skipOldReports;
    private static final String DEFAULT_CHECKS_NAME = "Tests";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public JUnitResultArchiver(String testResults) {
        this.testResults = testResults;
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, false, testDataPublishers);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, keepLongStdio, false, testDataPublishers, 1.0);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, boolean keepProperties, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers, double healthScaleFactor) {
        this.testResults = testResults;
        this.setKeepLongStdio(keepLongStdio);
        this.setKeepProperties(keepProperties);
        this.setTestDataPublishers(testDataPublishers == null ? Collections.emptyList() : testDataPublishers);
        this.setHealthScaleFactor(healthScaleFactor);
        this.setAllowEmptyResults(false);
    }

    @Deprecated
    private TestResult parse(String expandedTestResults, Run<?, ?> run, @NonNull FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return JUnitResultArchiver.parse(this, null, expandedTestResults, run, workspace, launcher, listener);
    }

    private static TestResult parse(@NonNull JUnitTask task, PipelineTestDetails pipelineTestDetails, String expandedTestResults, Run<?, ?> run, @NonNull FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return new JUnitParser(task.getParsedStdioRetention(), task.isKeepProperties(), task.isAllowEmptyResults(), task.isSkipOldReports()).parseResult(expandedTestResults, (Run)run, pipelineTestDetails, workspace, launcher, listener);
    }

    @Deprecated
    protected TestResult parse(String expandedTestResults, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IllegalArgumentException("The provided build has no workspace");
        }
        return this.parse(expandedTestResults, (Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
    }

    public void perform(Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (JUnitResultArchiver.parseAndSummarize(this, null, build, workspace, launcher, listener).getFailCount() > 0 && !this.skipMarkingBuildUnstable) {
            build.setResult(Result.UNSTABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static TestResultAction parseAndAttach(@NonNull JUnitTask task, PipelineTestDetails pipelineTestDetails, Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println(Messages.JUnitResultArchiver_Recording());
        String testResults = build.getEnvironment(listener).expand(task.getTestResults());
        TestResult result = JUnitResultArchiver.parse(task, pipelineTestDetails, testResults, build, workspace, launcher, listener);
        Run run = build;
        synchronized (run) {
            boolean appending;
            TestResultAction action = (TestResultAction)build.getAction(TestResultAction.class);
            if (action == null) {
                appending = false;
                action = new TestResultAction(build, result, listener);
            } else {
                appending = true;
                result.freeze(action);
                action.mergeResult(result, listener);
            }
            action.setHealthScaleFactor(task.getHealthScaleFactor());
            if (result.isEmpty()) {
                if (build.getResult() == Result.FAILURE) {
                    return null;
                }
                if (task.isAllowEmptyResults()) {
                    listener.getLogger().println(Messages.JUnitResultArchiver_ResultIsEmpty());
                    return null;
                }
                throw new AbortException(Messages.JUnitResultArchiver_ResultIsEmpty());
            }
            if (task.getTestDataPublishers() != null) {
                for (TestDataPublisher tdp : task.getTestDataPublishers()) {
                    TestResultAction.Data d = tdp.contributeTestData(build, workspace, launcher, listener, result);
                    if (d == null) continue;
                    action.addData(d);
                }
            }
            if (appending) {
                build.save();
            } else {
                build.addAction((Action)action);
            }
            return action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestResultSummary parseAndSummarize(@NonNull JUnitTask task, PipelineTestDetails pipelineTestDetails, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        TestResultSummary summary;
        TestResult result;
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (storage instanceof FileJunitTestResultStorage) {
            listener.getLogger().println(Messages.JUnitResultArchiver_Recording());
        }
        String testResults = build.getEnvironment(listener).expand(task.getTestResults());
        if (storage instanceof FileJunitTestResultStorage) {
            result = JUnitResultArchiver.parse(task, pipelineTestDetails, testResults, build, workspace, launcher, listener);
            summary = null;
        } else {
            result = new TestResult(storage.load(build.getParent().getFullName(), build.getNumber()));
            summary = new JUnitParser(task.getParsedStdioRetention(), task.isKeepProperties(), task.isAllowEmptyResults(), task.isSkipOldReports()).summarizeResult(testResults, build, pipelineTestDetails, workspace, launcher, listener, storage);
        }
        Run<?, ?> run = build;
        synchronized (run) {
            boolean appending;
            TestResultAction action = (TestResultAction)build.getAction(TestResultAction.class);
            if (action == null) {
                appending = false;
                action = new TestResultAction(build, result, listener);
            } else {
                appending = true;
                if (storage instanceof FileJunitTestResultStorage) {
                    result.freeze(action);
                    action.mergeResult(result, listener);
                }
            }
            if (summary == null) {
                assert (storage instanceof FileJunitTestResultStorage);
                summary = new TestResultSummary(result);
            }
            action.setHealthScaleFactor(task.getHealthScaleFactor());
            if (summary.getTotalCount() == 0 && build.getResult() != Result.FAILURE) {
                if (task.isAllowEmptyResults()) {
                    listener.getLogger().println(Messages.JUnitResultArchiver_ResultIsEmpty());
                } else {
                    throw new AbortException(Messages.JUnitResultArchiver_ResultIsEmpty());
                }
            }
            if (task.getTestDataPublishers() != null) {
                for (TestDataPublisher tdp : task.getTestDataPublishers()) {
                    TestResultAction.Data d = tdp.contributeTestData(build, workspace, launcher, listener, result);
                    if (d == null) continue;
                    action.addData(d);
                }
            }
            if (appending) {
                build.save();
            } else if (summary.getTotalCount() > 0) {
                build.addAction((Action)action);
            }
            if (!task.isSkipPublishingChecks()) {
                String checksName = task.getChecksName();
                if (checksName == null && pipelineTestDetails != null) {
                    ArrayList<String> checksComponents = new ArrayList<String>(pipelineTestDetails.getEnclosingBlockNames());
                    checksComponents.add(DEFAULT_CHECKS_NAME);
                    Collections.reverse(checksComponents);
                    checksName = String.join((CharSequence)" / ", checksComponents);
                }
                if (Util.fixEmpty((String)checksName) == null) {
                    checksName = DEFAULT_CHECKS_NAME;
                }
                try {
                    new JUnitChecksPublisher(build, checksName, result, summary).publishChecks(listener);
                }
                catch (Exception x) {
                    Functions.printStackTrace((Throwable)x, (PrintWriter)listener.error("Publishing JUnit checks failed:"));
                }
            }
            return summary;
        }
    }

    protected TestResult parseResult(DirectoryScanner ds, long buildTime) throws IOException {
        return new TestResult(buildTime, ds);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Override
    public String getTestResults() {
        return this.testResults;
    }

    @Override
    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public final void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Override
    @NonNull
    public List<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public final void setTestDataPublishers(@NonNull List<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = new DescribableList(Saveable.NOOP);
        this.testDataPublishers.addAll(testDataPublishers);
    }

    @Deprecated
    @DataBoundSetter
    public final void setKeepLongStdio(boolean keepLongStdio) {
        this.stdioRetention = StdioRetention.fromKeepLongStdio(keepLongStdio).name();
    }

    @Override
    @Deprecated
    public boolean isKeepLongStdio() {
        return StdioRetention.ALL == this.getParsedStdioRetention();
    }

    @Override
    public String getStdioRetention() {
        return this.stdioRetention == null ? StdioRetention.DEFAULT.name() : this.stdioRetention;
    }

    @DataBoundSetter
    public final void setStdioRetention(String stdioRetention) {
        this.stdioRetention = stdioRetention;
    }

    @Override
    public boolean isKeepProperties() {
        return this.keepProperties;
    }

    @DataBoundSetter
    public final void setKeepProperties(boolean keepProperties) {
        this.keepProperties = keepProperties;
    }

    @Override
    public boolean isAllowEmptyResults() {
        return this.allowEmptyResults;
    }

    @Override
    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @Override
    public String getChecksName() {
        return this.checksName;
    }

    @DataBoundSetter
    public void setChecksName(String checksName) {
        this.checksName = checksName;
    }

    @DataBoundSetter
    public final void setAllowEmptyResults(boolean allowEmptyResults) {
        this.allowEmptyResults = allowEmptyResults;
    }

    public boolean isSkipMarkingBuildUnstable() {
        return this.skipMarkingBuildUnstable;
    }

    @DataBoundSetter
    public void setSkipMarkingBuildUnstable(boolean skipMarkingBuildUnstable) {
        this.skipMarkingBuildUnstable = skipMarkingBuildUnstable;
    }

    @Override
    public boolean isSkipOldReports() {
        return this.skipOldReports;
    }

    @DataBoundSetter
    public void setSkipOldReports(boolean skipOldReports) {
        this.skipOldReports = skipOldReports;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.JUnitResultArchiver_DisplayName();
        }

        public FormValidation doCheckTestResults(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (project == null || !project.hasPermission(Item.WORKSPACE)) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckHealthScaleFactor(@QueryParameter double value) {
            if (value < 1.0E-7) {
                return FormValidation.warning((String)"Test health reporting disabled");
            }
            return FormValidation.ok((String)Messages.JUnitResultArchiver_HealthScaleFactorAnalysis(1, (int)(100.0 - Math.max(0.0, Math.min(100.0, 1.0 * value))), 5, (int)(100.0 - Math.max(0.0, Math.min(100.0, 5.0 * value)))));
        }

        public ListBoxModel doFillStdioRetentionItems(@QueryParameter(value="stdioRetention") String value) {
            StdioRetention selectedOption;
            ListBoxModel result = new ListBoxModel();
            try {
                selectedOption = StdioRetention.parse(value);
            }
            catch (IllegalArgumentException e) {
                selectedOption = StdioRetention.DEFAULT;
            }
            for (StdioRetention option : StdioRetention.values()) {
                result.add((Object)new ListBoxModel.Option(option.getDisplayName(), option.name(), option == selectedOption));
            }
            return result;
        }
    }
}

