/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JUnitResultsStep
extends Step
implements JUnitTask {
    private final String testResults;
    private String stdioRetention;
    private boolean keepProperties;
    private DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;
    private Double healthScaleFactor;
    private boolean allowEmptyResults;
    private boolean skipPublishingChecks;
    private String checksName;
    private boolean skipMarkingBuildUnstable;
    private boolean skipOldReports;

    @DataBoundConstructor
    public JUnitResultsStep(String testResults) {
        this.testResults = testResults;
    }

    @Override
    public String getTestResults() {
        return this.testResults;
    }

    @Override
    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public final void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Override
    @NonNull
    public List<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public final void setTestDataPublishers(@NonNull List<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = new DescribableList(Saveable.NOOP);
        this.testDataPublishers.addAll(testDataPublishers);
    }

    @Deprecated
    @DataBoundSetter
    public final void setKeepLongStdio(boolean keepLongStdio) {
        this.stdioRetention = StdioRetention.fromKeepLongStdio(keepLongStdio).name();
    }

    @Override
    @Deprecated
    public boolean isKeepLongStdio() {
        return StdioRetention.ALL == this.getParsedStdioRetention();
    }

    @Override
    public String getStdioRetention() {
        return this.stdioRetention == null ? StdioRetention.DEFAULT.name() : this.stdioRetention;
    }

    @DataBoundSetter
    public final void setStdioRetention(String stdioRetention) {
        this.stdioRetention = stdioRetention;
    }

    @Override
    public boolean isKeepProperties() {
        return this.keepProperties;
    }

    @DataBoundSetter
    public final void setKeepProperties(boolean keepProperties) {
        this.keepProperties = keepProperties;
    }

    @Override
    public boolean isAllowEmptyResults() {
        return this.allowEmptyResults;
    }

    @Override
    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @Override
    public String getChecksName() {
        return Util.fixEmpty((String)this.checksName);
    }

    @DataBoundSetter
    public void setChecksName(String checksName) {
        this.checksName = checksName;
    }

    @DataBoundSetter
    public final void setAllowEmptyResults(boolean allowEmptyResults) {
        this.allowEmptyResults = allowEmptyResults;
    }

    public boolean isSkipMarkingBuildUnstable() {
        return this.skipMarkingBuildUnstable;
    }

    @DataBoundSetter
    public void setSkipMarkingBuildUnstable(boolean skipMarkingBuildUnstable) {
        this.skipMarkingBuildUnstable = skipMarkingBuildUnstable;
    }

    @Override
    public boolean isSkipOldReports() {
        return this.skipOldReports;
    }

    @DataBoundSetter
    public void setSkipOldReports(boolean skipOldReports) {
        this.skipOldReports = skipOldReports;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new JUnitResultsStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "junit";
        }

        @NonNull
        public String getDisplayName() {
            return "Archive JUnit-formatted test results";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FilePath.class, FlowNode.class, TaskListener.class, Launcher.class);
            return Collections.unmodifiableSet(context);
        }

        public FormValidation doCheckHealthScaleFactor(@QueryParameter double value) {
            if (value < 1.0E-7) {
                return FormValidation.warning((String)"Test health reporting disabled");
            }
            return FormValidation.ok((String)Messages.JUnitResultArchiver_HealthScaleFactorAnalysis(1, (int)(100.0 - Math.max(0.0, Math.min(100.0, 1.0 * value))), 5, (int)(100.0 - Math.max(0.0, Math.min(100.0, 5.0 * value)))));
        }
    }
}

