/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.AbstractAuthorizationPropertyConverter;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.AuthorizationPropertyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritParentStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.GET;

public class AuthorizationMatrixProperty
extends JobProperty<Job<?, ?>>
implements AuthorizationProperty {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
    private final Set<String> sids = new HashSet<String>();
    @Deprecated
    private transient Boolean blocksInheritance;
    private InheritanceStrategy inheritanceStrategy = new InheritParentStrategy();
    private static final Logger LOGGER = Logger.getLogger(AuthorizationMatrixProperty.class.getName());

    private AuthorizationMatrixProperty() {
    }

    public AuthorizationMatrixProperty(Map<Permission, Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), new HashSet(e.getValue()));
        }
    }

    @DataBoundConstructor
    public AuthorizationMatrixProperty(List<String> permissions) {
        for (String str : permissions) {
            if (str == null) continue;
            this.add(str);
        }
    }

    public List<String> getPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        TreeMap<Permission, Set<String>> map = new TreeMap<Permission, Set<String>>(Comparator.comparing(Permission::getId));
        map.putAll(this.grantedPermissions);
        for (Map.Entry entry : map.entrySet()) {
            String permission = ((Permission)entry.getKey()).getId();
            for (String sid : new TreeSet((Collection)entry.getValue())) {
                permissions.add(permission + ":" + sid);
            }
        }
        return permissions;
    }

    public Set<String> getGroups() {
        return new HashSet<String>(this.sids);
    }

    @Override
    public Map<Permission, Set<String>> getGrantedPermissions() {
        return Collections.unmodifiableMap(this.grantedPermissions);
    }

    @Override
    public Permission getEditingPermission() {
        return Item.CONFIGURE;
    }

    @Override
    public void add(Permission p, String sid) {
        Set<String> set = this.grantedPermissions.get(p);
        if (set == null) {
            set = new HashSet<String>();
            this.grantedPermissions.put(p, set);
        }
        set.add(sid);
        this.sids.add(sid);
    }

    public SidACL getACL() {
        return this.acl;
    }

    @Override
    @DataBoundSetter
    public void setInheritanceStrategy(InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class ItemListenerImpl
    extends ItemListener {
        public void onCreated(Item item) {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof ProjectMatrixAuthorizationStrategy) {
                ProjectMatrixAuthorizationStrategy strategy = (ProjectMatrixAuthorizationStrategy)authorizationStrategy;
                if (item instanceof Job) {
                    User current;
                    String sid;
                    boolean propIsNew;
                    Job job = (Job)item;
                    AuthorizationMatrixProperty prop = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
                    boolean bl = propIsNew = prop == null;
                    if (propIsNew) {
                        prop = new AuthorizationMatrixProperty();
                    }
                    String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                    if (!strategy.getACL(job).hasPermission(Jenkins.getAuthentication(), Item.READ)) {
                        prop.add(Item.READ, sid);
                    }
                    if (!strategy.getACL(job).hasPermission(Jenkins.getAuthentication(), Item.CONFIGURE)) {
                        prop.add(Item.CONFIGURE, sid);
                    }
                    if (prop.getGrantedPermissions().size() > 0) {
                        try {
                            if (propIsNew) {
                                job.addProperty((JobProperty)prop);
                            } else {
                                job.save();
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Failed to grant creator permissions on job " + item.getFullName(), ex);
                        }
                    }
                }
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AuthorizationMatrixProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixProperty.class;
        }

        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As designed, implements a third state for the ternary logic")
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixProperty.this.hasPermission(this.toString(sid), p, sid instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"authorizationMatrix"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor
    implements AuthorizationPropertyDescriptor<AuthorizationMatrixProperty> {
        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.ITEM;
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)this.createNewInstance(req, formData, true);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return this.isApplicable();
        }

        @GET
        public FormValidation doCheckName(@AncestorInPath Job<?, ?> project, @QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)project, Item.CONFIGURE);
        }
    }
}

