/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.AuthorizationMatrixNodeProperty;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ProjectMatrixAuthorizationStrategy
extends GlobalMatrixAuthorizationStrategy {
    @Extension
    public static final Descriptor<AuthorizationStrategy> DESCRIPTOR = new GlobalMatrixAuthorizationStrategy.DescriptorImpl(){

        @Override
        protected GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.ProjectMatrixAuthorizationStrategy_DisplayName();
        }
    };

    @Nonnull
    public ACL getACL(@Nonnull Job<?, ?> project) {
        AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)project.getProperty(AuthorizationMatrixProperty.class);
        if (amp != null) {
            return amp.getInheritanceStrategy().getEffectiveACL((ACL)amp.getACL(), (AccessControlled)project);
        }
        return this.getACL(project.getParent());
    }

    @Restricted(value={NoExternalUse.class})
    public static ACL inheritingACL(final ACL parent, final ACL child) {
        if (parent instanceof SidACL && child instanceof SidACL) {
            return ((SidACL)child).newInheritingACL((SidACL)parent);
        }
        return new ACL(){

            public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                return a.equals(SYSTEM) || child.hasPermission(a, permission) || parent.hasPermission(a, permission);
            }
        };
    }

    public ACL getACL(ItemGroup<?> g) {
        if (g instanceof Item) {
            Item item = (Item)g;
            return item.getACL();
        }
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull Node node) {
        AuthorizationMatrixNodeProperty property = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AuthorizationMatrixNodeProperty.class);
        if (property != null) {
            return property.getInheritanceStrategy().getEffectiveACL((ACL)property.getACL(), (AccessControlled)node);
        }
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull AbstractItem item) {
        com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty p;
        if (Jenkins.get().getPlugin("cloudbees-folder") != null && item instanceof AbstractFolder && (p = (com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty)((AbstractFolder)item).getProperties().get(com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty.class)) != null) {
            return p.getInheritanceStrategy().getEffectiveACL((ACL)p.getACL(), (AccessControlled)item);
        }
        return this.getACL(item.getParent());
    }

    @Override
    @Nonnull
    public Set<String> getGroups() {
        TreeSet<String> r = new TreeSet<String>(new AuthorizationContainer.IdStrategyComparator());
        r.addAll(super.getGroups());
        for (Job j : Jenkins.get().getAllItems(Job.class)) {
            AuthorizationMatrixProperty jobProperty = (AuthorizationMatrixProperty)j.getProperty(AuthorizationMatrixProperty.class);
            if (jobProperty == null) continue;
            r.addAll(jobProperty.getGroups());
        }
        for (Job j : Jenkins.get().getAllItems(AbstractFolder.class)) {
            com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty folderProperty = (com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty)j.getProperties().get(com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty.class);
            if (folderProperty == null) continue;
            r.addAll(folderProperty.getGroups());
        }
        for (Node node : Jenkins.get().getNodes()) {
            AuthorizationMatrixNodeProperty nodeProperty = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AuthorizationMatrixNodeProperty.class);
            if (nodeProperty == null) continue;
            r.addAll(nodeProperty.getGroups());
        }
        return r;
    }

    @Restricted(value={DoNotUse.class})
    public static class ConverterImpl
    extends GlobalMatrixAuthorizationStrategy.ConverterImpl {
        @Override
        public GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        @Override
        public boolean canConvert(Class type) {
            return type == ProjectMatrixAuthorizationStrategy.class;
        }
    }
}

