/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.Extension;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class NonInheritingStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public NonInheritingStrategy() {
    }

    @Override
    public ACL getEffectiveACL(final ACL acl, AccessControlled subject) {
        final ACL rootACL = Jenkins.get().getAuthorizationStrategy().getRootACL();
        return new ACL(){

            public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                return this.isUltimatelyImpliedByAdminister(permission) && rootACL.hasPermission(a, Jenkins.ADMINISTER) || acl.hasPermission(a, permission);
            }

            private boolean isUltimatelyImpliedByAdminister(Permission permission) {
                while (permission.impliedBy != null) {
                    permission = permission.impliedBy;
                }
                return permission == Jenkins.ADMINISTER;
            }
        };
    }

    @Symbol(value={"nonInheriting"})
    @Extension(ordinal=-100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.NonInheritingStrategy_DisplayName();
        }
    }
}

