/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.integrations.casc;

import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.integrations.PermissionFinder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class MatrixAuthorizationStrategyConfigurator<T extends AuthorizationContainer>
extends BaseConfigurator<T> {
    private static final Logger LOGGER = Logger.getLogger(MatrixAuthorizationStrategyConfigurator.class.getName());

    @Nonnull
    public Class<?> getImplementedAPI() {
        return AuthorizationStrategy.class;
    }

    @Nonnull
    public Set<Attribute<T, ?>> describe() {
        return new HashSet(Arrays.asList(new MultivaluedAttribute("permissions", String.class).getter(MatrixAuthorizationStrategyConfigurator::getPermissions).setter(MatrixAuthorizationStrategyConfigurator::setPermissions), new MultivaluedAttribute("grantedPermissions", String.class).getter(unused -> null).setter(MatrixAuthorizationStrategyConfigurator::setPermissionsDeprecated)));
    }

    public static Collection<String> getPermissions(AuthorizationContainer container) {
        return container.getGrantedPermissions().entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(v -> ((Permission)e.getKey()).group.getId() + "/" + ((Permission)e.getKey()).name + ":" + v)).sorted().collect(Collectors.toList());
    }

    public static void setPermissions(AuthorizationContainer container, Collection<String> permissions) {
        permissions.forEach(p -> {
            int i = p.indexOf(58);
            Permission permission = PermissionFinder.findPermission(p.substring(0, i));
            container.add(permission, p.substring(i + 1));
        });
    }

    public static void setPermissionsDeprecated(AuthorizationContainer container, Collection<String> permissions) {
        LOGGER.log(Level.WARNING, "Loading deprecated attribute 'grantedPermissions' for instance of '" + container.getClass().getName() + "'. Use 'permissions' instead.");
        MatrixAuthorizationStrategyConfigurator.setPermissions(container, permissions);
    }
}

