/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.Messages;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;

public abstract class AxisDescriptor
extends Descriptor<Axis> {
    protected AxisDescriptor(Class<? extends Axis> clazz) {
        super(clazz);
    }

    protected AxisDescriptor() {
    }

    public boolean isInstantiable() {
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)Messages.AxisDescriptor_EmptyAxisName());
        }
        if (value.contains(",")) {
            return this.unsafeChar(',');
        }
        if (value.contains("=")) {
            return this.unsafeChar('=');
        }
        try {
            Jenkins.checkGoodName((String)value);
            return FormValidation.ok();
        }
        catch (Failure e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation checkValue(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)Messages.AxisDescriptor_EmptyAxisName());
        }
        if (value.contains(",")) {
            return this.unsafeChar(',');
        }
        return FormValidation.ok();
    }

    private FormValidation unsafeChar(char chr) {
        return FormValidation.error((String)("\u2018" + chr + "\u2019 is an unsafe character"));
    }
}

