/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.metrics.api.StringImmutableEntry;

public abstract class MetricProvider
implements ExtensionPoint {
    protected static Map.Entry<String, Metric> metric(String name, Metric metric) {
        return metric == null ? null : new StringImmutableEntry<Metric>(name, metric);
    }

    protected static MetricSet metrics(Map.Entry<String, Metric> ... metrics) {
        LinkedHashMap<String, Metric> result = new LinkedHashMap<String, Metric>(metrics.length);
        for (Map.Entry<String, Metric> metric : metrics) {
            if (metric == null || metric.getValue() == null) continue;
            result.put(metric.getKey(), metric.getValue());
        }
        return new FixedMetricSet(result);
    }

    protected static MetricSet metrics(Map<String, Metric> metrics) {
        LinkedHashMap<String, Metric> result = new LinkedHashMap<String, Metric>(metrics.size());
        for (Map.Entry<String, Metric> metric : metrics.entrySet()) {
            if (metric == null || metric.getValue() == null) continue;
            result.put(metric.getKey(), metric.getValue());
        }
        return new FixedMetricSet(result);
    }

    @NonNull
    public abstract MetricSet getMetricSet();

    private static class FixedMetricSet
    implements MetricSet {
        private final Map<String, Metric> result;

        public FixedMetricSet(Map<String, Metric> result) {
            this.result = Collections.unmodifiableMap(result);
        }

        public Map<String, Metric> getMetrics() {
            return this.result;
        }
    }
}

