/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.DerivativeGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.triggers.SafeTimerTask;
import hudson.util.PluginServletFilter;
import hudson.util.StreamTaskListener;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import jenkins.metrics.api.HealthCheckProvider;
import jenkins.metrics.api.HealthCheckProviderListener;
import jenkins.metrics.api.Messages;
import jenkins.metrics.api.MetricProvider;
import jenkins.metrics.api.MetricProviderListener;
import jenkins.metrics.api.MetricsAccessKey;
import jenkins.metrics.impl.MetricsFilter;
import jenkins.metrics.impl.ObjectNameFactoryImpl;
import jenkins.metrics.util.HealthChecksThreadPool;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.jcip.annotations.ThreadSafe;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;

public class Metrics
extends Plugin {
    public static final int HEALTH_CHECK_INTERVAL_MINS = Integer.getInteger(Metrics.class.getName() + ".HEALTH_CHECK_INTERVAL_MINS", 1);
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Metrics.class, Messages._Metrics_PermissionGroup());
    public static final Permission VIEW = new Permission(PERMISSIONS, "View", Messages._Metrics_ViewPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission THREAD_DUMP = new Permission(PERMISSIONS, "ThreadDump", Messages._Metrics_ThreadDumpPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission HEALTH_CHECK = new Permission(PERMISSIONS, "HealthCheck", Messages._Metrics_HealthCheckPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final String JMX_DOMAIN = "io.jenkins";
    private static final Pattern JMX_EXCLUSIONS = Pattern.compile("^(vm|system)\\..*|.*\\.(5m|15m|1h|history)$");
    private static final Logger LOGGER = Logger.getLogger(Metrics.class.getName());
    private static ExecutorService threadPoolForHealthChecks;
    private final transient MetricRegistry metricRegistry = new MetricRegistry();
    private final transient HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();
    private final transient MetricsFilter filter = new MetricsFilter();
    private JmxReporter jmxReporter;

    @NonNull
    public static HealthCheckRegistry healthCheckRegistry() {
        Metrics plugin = (Metrics)Jenkins.getInstance().getPlugin(Metrics.class);
        if (plugin == null || plugin.healthCheckRegistry == null) {
            throw new AssertionError((Object)(Metrics.class.getName() + " is missing its HealthCheckRegistry"));
        }
        return plugin.healthCheckRegistry;
    }

    @NonNull
    public static SortedMap<String, HealthCheck.Result> getHealthCheckResults() {
        HealthCheckData data = Metrics.getHealthCheckData();
        return data == null ? new TreeMap() : data.getResults();
    }

    @CheckForNull
    public static HealthCheckData getHealthCheckData() {
        HealthChecker healthChecker = (HealthChecker)((Object)ExtensionList.lookup(PeriodicWork.class).get(HealthChecker.class));
        if (healthChecker == null) {
            LOGGER.warning("Unable to get health check results, HealthChecker is not available");
            return null;
        }
        return healthChecker.getHealthCheckData();
    }

    @NonNull
    public static MetricRegistry metricRegistry() {
        Metrics plugin = (Metrics)Jenkins.getInstance().getPlugin(Metrics.class);
        if (plugin == null || plugin.metricRegistry == null) {
            throw new AssertionError((Object)(Metrics.class.getName() + " is missing its MetricRegistry"));
        }
        return plugin.metricRegistry;
    }

    private static MetricsAccessKey.DescriptorImpl accessKeyDescriptorOrDie() {
        MetricsAccessKey.DescriptorImpl descriptor = (MetricsAccessKey.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(MetricsAccessKey.DescriptorImpl.class);
        if (descriptor == null) {
            throw new IllegalStateException();
        }
        return descriptor;
    }

    public static void checkAccessKey(@CheckForNull String accessKey) {
        Metrics.accessKeyDescriptorOrDie().checkAccessKey(accessKey);
    }

    public static void checkAccessKeyPing(@CheckForNull String accessKey) {
        Metrics.accessKeyDescriptorOrDie().checkAccessKeyPing(accessKey);
    }

    public static void checkAccessKeyThreadDump(@CheckForNull String accessKey) {
        Metrics.accessKeyDescriptorOrDie().checkAccessKeyThreadDump(accessKey);
    }

    public static void checkAccessKeyHealthCheck(@CheckForNull String accessKey) {
        Metrics.accessKeyDescriptorOrDie().checkAccessKeyHealthCheck(accessKey);
    }

    public static void checkAccessKeyMetrics(@CheckForNull String accessKey) {
        Metrics.accessKeyDescriptorOrDie().checkAccessKeyMetrics(accessKey);
    }

    public static HttpResponse cors(@CheckForNull String accessKey, HttpResponse resp) {
        return Metrics.accessKeyDescriptorOrDie().cors(accessKey, resp);
    }

    public static void reindexAccessKeys() {
        Metrics.accessKeyDescriptorOrDie().reindexAccessKeys();
    }

    public void start() throws Exception {
        PluginServletFilter.addFilter((Filter)this.filter);
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain(JMX_DOMAIN).createsObjectNamesWith((ObjectNameFactory)new ObjectNameFactoryImpl()).filter((name, metric) -> !JMX_EXCLUSIONS.matcher(name).matches()).build();
        this.jmxReporter.start();
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void afterExtensionsAugmented() {
        LOGGER.log(Level.FINER, "Registering metric provider and health check provider extensions...");
        Jenkins jenkins = Jenkins.getInstance();
        Metrics plugin = (Metrics)jenkins.getPlugin(Metrics.class);
        if (plugin == null) {
            LOGGER.log(Level.WARNING, "Could not register metrics providers or health check providers as metrics plugin appears to be disabled");
            return;
        }
        if (plugin.metricRegistry == null || plugin.healthCheckRegistry == null) {
            LOGGER.log(Level.WARNING, "Could not register metrics providers or health check providers as metrics plugin appears have failed initialization");
            return;
        }
        LOGGER.log(Level.FINER, "Confirmed metrics plugin initialized");
        MetricProviderListener.attach(plugin.metricRegistry);
        HealthCheckProviderListener.attach(plugin.healthCheckRegistry);
        threadPoolForHealthChecks = new HealthChecksThreadPool(Metrics.healthCheckRegistry());
        LOGGER.log(Level.FINE, "Metric provider and health check provider extensions registered");
    }

    public void stop() throws Exception {
        if (this.filter != null) {
            PluginServletFilter.removeFilter((Filter)this.filter);
        }
        this.metricRegistry.removeMatching(MetricFilter.ALL);
        for (String name : this.healthCheckRegistry.getNames()) {
            this.healthCheckRegistry.unregister(name);
        }
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
            this.jmxReporter = null;
        }
    }

    @ThreadSafe
    public static class HealthCheckData {
        private final long lastModified;
        @CheckForNull
        private final Long expires;
        @NonNull
        private final SortedMap<String, HealthCheck.Result> results;

        public HealthCheckData(@NonNull SortedMap<String, HealthCheck.Result> results, long nextMillis) {
            this.results = results;
            this.lastModified = System.currentTimeMillis();
            this.expires = this.lastModified + nextMillis;
        }

        public HealthCheckData(@NonNull SortedMap<String, HealthCheck.Result> results) {
            this.results = results;
            this.lastModified = System.currentTimeMillis();
            this.expires = null;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        @CheckForNull
        public Long getExpires() {
            return this.expires;
        }

        @NonNull
        public SortedMap<String, HealthCheck.Result> getResults() {
            return this.results;
        }
    }

    @Extension
    public static class HealthChecker
    extends PeriodicWork {
        private static final Logger LOGGER = Logger.getLogger(HealthChecker.class.getName());
        private final com.codahale.metrics.Timer healthCheckDuration = new com.codahale.metrics.Timer();
        private HealthCheckData healthCheckData = null;
        private final Gauge<Integer> healthCheckCount = new Gauge<Integer>(){

            public Integer getValue() {
                return Metrics.healthCheckRegistry().getNames().size();
            }
        };
        private final Gauge<Double> healthCheckScore = new Gauge<Double>(){

            public Double getValue() {
                return score;
            }
        };
        private Future<?> future;
        private volatile double score = 1.0;
        private volatile Set<String> lastUnhealthy = null;

        public long getRecurrencePeriod() {
            return TimeUnit.MINUTES.toMillis(Math.min((long)Math.max(1, HEALTH_CHECK_INTERVAL_MINS), TimeUnit.DAYS.toMinutes(1L)));
        }

        public com.codahale.metrics.Timer getHealthCheckDuration() {
            return this.healthCheckDuration;
        }

        @NonNull
        @WithBridgeMethods(value={Map.class})
        public SortedMap<String, HealthCheck.Result> getHealthCheckResults() {
            return this.healthCheckData == null ? new TreeMap() : this.healthCheckData.results;
        }

        @CheckForNull
        public HealthCheckData getHealthCheckData() {
            return this.healthCheckData;
        }

        public Gauge<Integer> getHealthCheckCount() {
            return this.healthCheckCount;
        }

        public Gauge<Double> getHealthCheckScore() {
            return this.healthCheckScore;
        }

        public final void doRun() {
            try {
                if (this.future != null && !this.future.isDone()) {
                    LOGGER.log(Level.INFO, HealthChecker.class.getName() + " thread is still running. Execution aborted.");
                    return;
                }
                if (threadPoolForHealthChecks == null) {
                    LOGGER.info("Health checks thread pool not yet initialized, skipping until next execution");
                    return;
                }
                this.future = threadPoolForHealthChecks.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOGGER.log(Level.FINE, "Started " + HealthChecker.class.getName());
                        long startTime = System.currentTimeMillis();
                        StreamTaskListener l = null;
                        SecurityContext oldContext = ACL.impersonate((Authentication)ACL.SYSTEM);
                        try {
                            Jenkins jenkins = Jenkins.getInstance();
                            File logFile = HealthChecker.getLogFile(jenkins);
                            if (!logFile.isFile()) {
                                File oldFile = new File(jenkins.getRootDir(), HealthChecker.class.getName() + ".log");
                                if (!logFile.getParentFile().isDirectory() && !logFile.getParentFile().mkdirs()) {
                                    LOGGER.log(Level.SEVERE, "Could not create logs directory: {0}", logFile.getParentFile());
                                }
                                if (oldFile.isFile() && !oldFile.renameTo(logFile)) {
                                    LOGGER.log(Level.WARNING, "Could not migrate old log file from {0} to {1}", new Object[]{oldFile, logFile});
                                }
                            }
                            l = new StreamTaskListener(logFile);
                            this.execute((TaskListener)l);
                        }
                        catch (IOException e) {
                            if (l != null) {
                                e.printStackTrace(l.fatalError(e.getMessage()));
                            } else {
                                LOGGER.log(Level.SEVERE, HealthChecker.class.getName() + " could not create listener", e);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(l.fatalError("aborted"));
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Error running " + HealthChecker.class.getName(), e);
                            if (l != null) {
                                e.printStackTrace(l.fatalError(e.getMessage()));
                            }
                        }
                        finally {
                            if (l != null) {
                                l.closeQuietly();
                            }
                            SecurityContextHolder.setContext((SecurityContext)oldContext);
                        }
                        LOGGER.log(Level.FINE, "Finished " + HealthChecker.class.getName() + ". " + (System.currentTimeMillis() - startTime) + " ms");
                    }
                });
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, HealthChecker.class.getName() + " thread failed with error", t);
            }
        }

        static File getLogFile(Jenkins jenkins) {
            File logsRoot = new File(jenkins.getRootDir(), "logs");
            try {
                Method getLogsRoot = SafeTimerTask.class.getMethod("getLogsRoot", new Class[0]);
                logsRoot = (File)getLogsRoot.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException getLogsRoot) {
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return new File(logsRoot, "health-checker.log");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(TaskListener listener) throws IOException, InterruptedException {
            SortedMap results;
            if (Jenkins.getInstance().getInitLevel().compareTo((Enum)InitMilestone.COMPLETED) < 0) {
                return;
            }
            Metrics.reindexAccessKeys();
            HealthCheckRegistry registry = Metrics.healthCheckRegistry();
            HashSet<String> defined = new HashSet<String>(registry.getNames());
            HashSet removed = new HashSet(defined);
            for (HealthCheckProvider p : ExtensionList.lookup(HealthCheckProvider.class)) {
                for (Map.Entry<String, HealthCheck> c : p.getHealthChecks().entrySet()) {
                    removed.remove(c.getKey());
                    if (defined.contains(c.getKey())) continue;
                    registry.register(c.getKey(), c.getValue());
                    defined.add(c.getKey());
                }
            }
            for (String key : removed) {
                registry.unregister(key);
            }
            listener.getLogger().println("Starting health checks at " + new Date());
            Timer.Context context = this.healthCheckDuration.time();
            try {
                results = registry.runHealthChecks(threadPoolForHealthChecks);
            }
            catch (RejectedExecutionException e) {
                listener.error("Health checks execution was rejected instead of queued: {0}", new Object[]{e});
                LOGGER.log(Level.WARNING, "Health checks execution was rejected instead of queued: {0}", e);
                return;
            }
            finally {
                context.stop();
            }
            this.healthCheckData = new HealthCheckData(results, this.getRecurrencePeriod());
            listener.getLogger().println("Health check results at " + new Date() + ":");
            TreeSet<String> unhealthy = null;
            TreeSet unhealthyName = null;
            int count = 0;
            int total = 0;
            for (Map.Entry e : results.entrySet()) {
                ++count;
                listener.getLogger().println(" * " + (String)e.getKey() + ": " + e.getValue());
                if (((HealthCheck.Result)e.getValue()).isHealthy()) {
                    ++total;
                    continue;
                }
                if (unhealthy == null) {
                    unhealthy = new TreeSet<String>();
                    unhealthyName = new TreeSet();
                }
                unhealthy.add((String)e.getKey() + " : " + ((HealthCheck.Result)e.getValue()).getMessage());
                unhealthyName.add(e.getKey());
            }
            this.score = (double)total / (double)count;
            Set<String> lastUnhealthy = this.lastUnhealthy;
            this.lastUnhealthy = unhealthyName;
            if (unhealthy != null) {
                if (lastUnhealthy == null || lastUnhealthy.size() < unhealthyName.size() || !lastUnhealthy.equals(unhealthyName)) {
                    LOGGER.log(Level.WARNING, "Some health checks are reporting as unhealthy: {0}", unhealthy);
                } else if (lastUnhealthy.equals(unhealthyName)) {
                    LOGGER.log(Level.FINE, "Some health checks are reporting as unhealthy: {0}", unhealthy);
                } else {
                    LOGGER.log(Level.INFO, "{0} fewer health checks are reporting as unhealthy: {1}", new Object[]{lastUnhealthy.size() - unhealthyName.size(), unhealthy});
                }
            } else if (lastUnhealthy != null) {
                LOGGER.log(Level.INFO, "All health checks are reporting as healthy");
            }
        }

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        @Restricted(value={DoNotUse.class})
        public static void dynamicInstallHack() {
            PeriodicWork p;
            VersionNumber version;
            if (Jenkins.getInstance().getInitLevel() == InitMilestone.COMPLETED && (version = Jenkins.getVersion()) != null && version.isOlderThan(new VersionNumber("2.129")) && (p = (PeriodicWork)ExtensionList.lookup(PeriodicWork.class).get(HealthChecker.class)) != null) {
                Timer.get().scheduleAtFixedRate((Runnable)p, p.getInitialDelay(), p.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Extension
    public static class HealthCheckMetricsProvider
    extends MetricProvider {
        @Override
        @NonNull
        public MetricSet getMetricSet() {
            HealthChecker c = (HealthChecker)((Object)ExtensionList.lookup(PeriodicWork.class).get(HealthChecker.class));
            if (c == null) {
                throw new AssertionError((Object)"HealthChecker is missing");
            }
            return HealthCheckMetricsProvider.metrics(HealthCheckMetricsProvider.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"health-check", "duration"}), (Metric)c.getHealthCheckDuration()), HealthCheckMetricsProvider.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"health-check", "count"}), c.getHealthCheckCount()), HealthCheckMetricsProvider.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"health-check", "score"}), c.getHealthCheckScore()), HealthCheckMetricsProvider.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"health-check", "inverse-score"}), (Metric)new DerivativeGauge<Double, Double>(c.getHealthCheckScore()){

                protected Double transform(Double value) {
                    return value == null ? null : Double.valueOf(1.0 - value);
                }
            }));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static class HeathCheckMetricsProvider
    extends HealthCheckMetricsProvider {
    }
}

