/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.DerivativeGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.RunListener;
import hudson.model.queue.QueueListener;
import hudson.model.queue.WorkUnit;
import hudson.model.queue.WorkUnitContext;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import hudson.util.VersionNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.metrics.api.MetricProvider;
import jenkins.metrics.api.Metrics;
import jenkins.metrics.api.QueueItemMetricsEvent;
import jenkins.metrics.api.QueueItemMetricsListener;
import jenkins.metrics.impl.RunResolver;
import jenkins.metrics.impl.SubTaskTimeInQueueAction;
import jenkins.metrics.impl.TimeInQueueAction;
import jenkins.metrics.util.AutoSamplingHistogram;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Extension
public class JenkinsMetricProviderImpl
extends MetricProvider {
    private static final Logger LOGGER = Logger.getLogger(JenkinsMetricProviderImpl.class.getName());
    private MetricSet set;
    private AutoSamplingHistogram jenkinsNodeTotalCount;
    private AutoSamplingHistogram jenkinsNodeOnlineCount;
    private AutoSamplingHistogram jenkinsExecutorTotalCount;
    private AutoSamplingHistogram jenkinsExecutorUsedCount;
    private Map<Computer, Timer> computerBuildDurations = new WeakHashMap<Computer, Timer>();
    private Meter jenkinsJobScheduleRate;
    private Timer jenkinsJobQueueDuration;
    private Timer jenkinsJobWaitingDuration;
    private Timer jenkinsJobBlockedDuration;
    private Timer jenkinsJobBuildableDuration;
    private Timer jenkinsJobBuildingDuration;
    private Meter jenkinsTaskScheduleRate;
    private Timer jenkinsTaskQueueDuration;
    private Timer jenkinsTaskWaitingDuration;
    private Timer jenkinsTaskBlockedDuration;
    private Timer jenkinsTaskBuildableDuration;
    private Timer jenkinsTaskExecutionDuration;
    private Timer jenkinsJobExecutionTime;
    private HashMap<String, Meter> jenkinsRunResults = new HashMap();
    private Timer jenkinsJobTotalDuration;

    public JenkinsMetricProviderImpl() {
        CachedGauge<QueueStats> jenkinsQueue = new CachedGauge<QueueStats>(1L, TimeUnit.SECONDS){

            protected QueueStats loadValue() {
                try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                    Queue queue = Jenkins.getInstance().getQueue();
                    int length = 0;
                    int blocked = 0;
                    int buildable = 0;
                    int pending = queue == null ? 0 : queue.getPendingItems().size();
                    int stuck = 0;
                    if (queue != null) {
                        for (Queue.Item i : queue.getItems()) {
                            if (i == null) continue;
                            ++length;
                            try {
                                if (i.isBlocked()) {
                                    ++blocked;
                                }
                                if (i.isBuildable()) {
                                    ++buildable;
                                }
                                if (!i.isStuck()) continue;
                                ++stuck;
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, "Uncaught exception recording queue statistics", e);
                            }
                            catch (OutOfMemoryError e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                LOGGER.log(Level.FINE, "Uncaught throwable recording queue statistics", e);
                            }
                        }
                    }
                    QueueStats queueStats = new QueueStats(length, blocked, buildable, pending, stuck);
                    return queueStats;
                }
            }
        };
        CachedGauge<NodeStats> jenkinsNodes = new CachedGauge<NodeStats>(1L, TimeUnit.SECONDS){

            protected NodeStats loadValue() {
                try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                    int nodeCount = 0;
                    int nodeOnline = 0;
                    int executorCount = 0;
                    int executorBuilding = 0;
                    Jenkins jenkins = Jenkins.getInstance();
                    if (jenkins.getNumExecutors() > 0) {
                        ++nodeCount;
                        Computer computer = jenkins.toComputer();
                        if (computer != null && !computer.isOffline()) {
                            ++nodeOnline;
                            for (Executor e : computer.getExecutors()) {
                                ++executorCount;
                                if (e.isIdle()) continue;
                                ++executorBuilding;
                            }
                        }
                    }
                    for (Node node : jenkins.getNodes()) {
                        ++nodeCount;
                        Computer computer = node.toComputer();
                        if (computer == null || computer.isOffline()) continue;
                        ++nodeOnline;
                        for (Executor e : computer.getExecutors()) {
                            ++executorCount;
                            if (e.isIdle()) continue;
                            ++executorBuilding;
                        }
                    }
                    NodeStats nodeStats = new NodeStats(nodeCount, nodeOnline, executorCount, executorBuilding);
                    return nodeStats;
                }
            }
        };
        CachedGauge<JobStats> jobStats = new CachedGauge<JobStats>(5L, TimeUnit.MINUTES){

            protected JobStats loadValue() {
                try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                    int count = 0;
                    int disabledProjects = 0;
                    int projectCount = 0;
                    long depthTotal = 0L;
                    Stack<Object> q = new Stack<Object>();
                    q.push(Jenkins.getInstance());
                    while (!q.isEmpty()) {
                        ItemGroup parent = (ItemGroup)q.pop();
                        int depth = 0;
                        ItemGroup p = parent;
                        while (p != null) {
                            ++depth;
                            p = p instanceof Item ? ((Item)p).getParent() : null;
                        }
                        for (Item i : parent.getItems()) {
                            if (!(i instanceof TopLevelItem)) continue;
                            if (i instanceof Job) {
                                ++count;
                                depthTotal += (long)depth;
                                if (i instanceof ParameterizedJobMixIn.ParameterizedJob) {
                                    ++projectCount;
                                    if (((ParameterizedJobMixIn.ParameterizedJob)i).isDisabled()) {
                                        ++disabledProjects;
                                    }
                                }
                            }
                            if (!(i instanceof ItemGroup)) continue;
                            q.push((ItemGroup)i);
                        }
                    }
                    JobStats jobStats = new JobStats(count, projectCount, disabledProjects, count == 0 ? 0.0 : (double)depthTotal / (double)count);
                    return jobStats;
                }
            }
        };
        Map.Entry[] entryArray = new Map.Entry[35];
        entryArray[0] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"queue", "size"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<QueueStats, Integer>((Gauge)jenkinsQueue){

            protected Integer transform(QueueStats value) {
                return value.getLength();
            }
        }).toMetricSet());
        entryArray[1] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"queue", "blocked"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<QueueStats, Integer>((Gauge)jenkinsQueue){

            protected Integer transform(QueueStats value) {
                return value.getBlocked();
            }
        }).toMetricSet());
        entryArray[2] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"queue", "buildable"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<QueueStats, Integer>((Gauge)jenkinsQueue){

            protected Integer transform(QueueStats value) {
                return value.getBuildable();
            }
        }).toMetricSet());
        entryArray[3] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"queue", "stuck"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<QueueStats, Integer>((Gauge)jenkinsQueue){

            protected Integer transform(QueueStats value) {
                return value.getStuck();
            }
        }).toMetricSet());
        entryArray[4] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"queue", "pending"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<QueueStats, Integer>((Gauge)jenkinsQueue){

            protected Integer transform(QueueStats value) {
                return value.getPending();
            }
        }).toMetricSet());
        this.jenkinsNodeTotalCount = new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getNodeCount();
            }
        });
        entryArray[5] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"node", "count"}), (Metric)this.jenkinsNodeTotalCount.toMetricSet());
        this.jenkinsNodeOnlineCount = new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getNodeOnline();
            }
        });
        entryArray[6] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"node", "online"}), (Metric)this.jenkinsNodeOnlineCount.toMetricSet());
        entryArray[7] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"node", "offline"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getNodeOffline();
            }
        }).toMetricSet());
        this.jenkinsExecutorTotalCount = new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getExecutorCount();
            }
        });
        entryArray[8] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"executor", "count"}), (Metric)this.jenkinsExecutorTotalCount.toMetricSet());
        this.jenkinsExecutorUsedCount = new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getExecutorBuilding();
            }
        });
        entryArray[9] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"executor", "in-use"}), (Metric)this.jenkinsExecutorUsedCount.toMetricSet());
        entryArray[10] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"executor", "free"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<NodeStats, Integer>((Gauge)jenkinsNodes){

            protected Integer transform(NodeStats value) {
                return value.getExecutorAvailable();
            }
        }).toMetricSet());
        this.jenkinsJobScheduleRate = new Meter();
        entryArray[11] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "scheduled"}), (Metric)this.jenkinsJobScheduleRate);
        this.jenkinsTaskScheduleRate = new Meter();
        entryArray[12] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "scheduled"}), (Metric)this.jenkinsTaskScheduleRate);
        entryArray[13] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "count"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<JobStats, Integer>((Gauge)jobStats){

            protected Integer transform(JobStats value) {
                return value.getJobCount();
            }
        }).toMetricSet());
        entryArray[14] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "averageDepth"}), (Metric)new DerivativeGauge<JobStats, Double>((Gauge)jobStats){

            protected Double transform(JobStats value) {
                return value.getDepthAverage();
            }
        });
        entryArray[15] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"project", "count"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<JobStats, Integer>((Gauge)jobStats){

            protected Integer transform(JobStats value) {
                return value.getProjectCount();
            }
        }).toMetricSet());
        entryArray[16] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"project", "enabled", "count"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<JobStats, Integer>((Gauge)jobStats){

            protected Integer transform(JobStats value) {
                return value.getEnabledProjectCount();
            }
        }).toMetricSet());
        entryArray[17] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"project", "disabled", "count"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)new DerivativeGauge<JobStats, Integer>((Gauge)jobStats){

            protected Integer transform(JobStats value) {
                return value.getDisabledProjectCount();
            }
        }).toMetricSet());
        this.jenkinsJobQueueDuration = new Timer();
        entryArray[18] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "queuing", "duration"}), (Metric)this.jenkinsJobQueueDuration);
        this.jenkinsJobWaitingDuration = new Timer();
        entryArray[19] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "waiting", "duration"}), (Metric)this.jenkinsJobWaitingDuration);
        this.jenkinsJobBlockedDuration = new Timer();
        entryArray[20] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "blocked", "duration"}), (Metric)this.jenkinsJobBlockedDuration);
        this.jenkinsJobBuildableDuration = new Timer();
        entryArray[21] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "buildable", "duration"}), (Metric)this.jenkinsJobBuildableDuration);
        this.jenkinsJobBuildingDuration = new Timer();
        entryArray[22] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "building", "duration"}), (Metric)this.jenkinsJobBuildingDuration);
        this.jenkinsJobExecutionTime = new Timer();
        entryArray[23] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "execution", "time"}), (Metric)this.jenkinsJobExecutionTime);
        this.jenkinsTaskQueueDuration = new Timer();
        entryArray[24] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "queuing", "duration"}), (Metric)this.jenkinsTaskQueueDuration);
        this.jenkinsTaskWaitingDuration = new Timer();
        entryArray[25] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "waiting", "duration"}), (Metric)this.jenkinsTaskWaitingDuration);
        this.jenkinsTaskBlockedDuration = new Timer();
        entryArray[26] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "blocked", "duration"}), (Metric)this.jenkinsTaskBlockedDuration);
        this.jenkinsTaskBuildableDuration = new Timer();
        entryArray[27] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "buildable", "duration"}), (Metric)this.jenkinsTaskBuildableDuration);
        this.jenkinsTaskExecutionDuration = new Timer();
        entryArray[28] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"task", "execution", "duration"}), (Metric)this.jenkinsTaskExecutionDuration);
        this.jenkinsJobTotalDuration = new Timer();
        entryArray[29] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"job", "total", "duration"}), (Metric)this.jenkinsJobTotalDuration);
        entryArray[30] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"plugins", "active"}), (Metric)new CachedGauge<Integer>(5L, TimeUnit.MINUTES){

            protected Integer loadValue() {
                int count = 0;
                Jenkins jenkins = Jenkins.getInstance();
                for (PluginWrapper w : jenkins.getPluginManager().getPlugins()) {
                    if (!w.isActive()) continue;
                    ++count;
                }
                return count;
            }
        });
        entryArray[31] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"plugins", "inactive"}), (Metric)new CachedGauge<Integer>(5L, TimeUnit.MINUTES){

            protected Integer loadValue() {
                int count = 0;
                Jenkins jenkins = Jenkins.getInstance();
                for (PluginWrapper w : jenkins.getPluginManager().getPlugins()) {
                    if (w.isActive()) continue;
                    ++count;
                }
                return count;
            }
        });
        entryArray[32] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"plugins", "failed"}), (Metric)new CachedGauge<Integer>(5L, TimeUnit.MINUTES){

            protected Integer loadValue() {
                Jenkins jenkins = Jenkins.getInstance();
                return jenkins.getPluginManager().getFailedPlugins().size();
            }
        });
        entryArray[33] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"plugins", "withUpdate"}), (Metric)new CachedGauge<Integer>(5L, TimeUnit.MINUTES){

            protected Integer loadValue() {
                int count = 0;
                Jenkins jenkins = Jenkins.getInstance();
                for (PluginWrapper w : jenkins.getPluginManager().getPlugins()) {
                    if (!w.hasUpdate()) continue;
                    ++count;
                }
                return count;
            }
        });
        entryArray[34] = JenkinsMetricProviderImpl.metric(MetricRegistry.name((String)"jenkins", (String[])new String[]{"runs"}), (Metric)this.runCounters());
        this.set = JenkinsMetricProviderImpl.metrics(entryArray);
    }

    private static boolean computerBuildDurationTimers(String s, Metric metric) {
        return s.startsWith("jenkins.node.") && s.endsWith(".builds") && s.length() > "jenkins.node..builds".length() && metric instanceof Timer;
    }

    private MetricSet runCounters() {
        HashMap<String, Meter> runCounters = new HashMap<String, Meter>();
        for (String resultName : ResultRunListener.ALL) {
            Meter counter = new Meter();
            this.jenkinsRunResults.put(resultName, counter);
            runCounters.put(resultName, counter);
        }
        return () -> runCounters;
    }

    public static JenkinsMetricProviderImpl instance() {
        return (JenkinsMetricProviderImpl)ExtensionList.lookup(MetricProvider.class).get(JenkinsMetricProviderImpl.class);
    }

    @Override
    @NonNull
    public MetricSet getMetricSet() {
        return this.set;
    }

    public Histogram getJenkinsExecutorTotalCount() {
        return this.jenkinsExecutorTotalCount;
    }

    public Histogram getJenkinsExecutorUsedCount() {
        return this.jenkinsExecutorUsedCount;
    }

    public Histogram getJenkinsNodeOnlineCount() {
        return this.jenkinsNodeOnlineCount;
    }

    public Histogram getJenkinsNodeTotalCount() {
        return this.jenkinsNodeTotalCount;
    }

    private synchronized void updateMetrics() {
        Jenkins jenkins = Jenkins.getInstance();
        HashSet<String> nodeMetricNames = new HashSet<String>();
        for (Node node : jenkins.getNodes()) {
            nodeMetricNames.add(MetricRegistry.name((String)"jenkins", (String[])new String[]{"node", node.getNodeName(), "builds"}));
            Computer computer = node.toComputer();
            if (computer == null) continue;
            this.getOrCreateTimer(computer);
        }
        MetricRegistry metricRegistry = Metrics.metricRegistry();
        metricRegistry.getTimers(JenkinsMetricProviderImpl::computerBuildDurationTimers).keySet().stream().filter(name -> !nodeMetricNames.contains(name)).forEach(arg_0 -> ((MetricRegistry)metricRegistry).remove(arg_0));
    }

    private synchronized Timer getOrCreateTimer(Computer computer) {
        return this.computerBuildDurations.computeIfAbsent(computer, c -> Metrics.metricRegistry().timer(MetricRegistry.name((String)"jenkins", (String[])new String[]{"node", c.getName(), "builds"})));
    }

    private static <V> Supplier<V> asSupplier(Future<V> future) {
        return () -> {
            try {
                return future.get();
            }
            catch (Throwable t) {
                JenkinsMetricProviderImpl.sneakyThrow(t);
                throw new RuntimeException(t);
            }
        };
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    @Extension
    public static class ScheduledRate
    extends QueueListener {
        private static final long TRIM_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(1L);
        private transient ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new ExceptionCatchingThreadFactory((ThreadFactory)new DaemonThreadFactory()), "QueueSubTaskMetrics"));
        private final Map<WorkUnitContext, TimeInQueueAction> actions = new WeakHashMap<WorkUnitContext, TimeInQueueAction>();
        private final Map<Queue.BlockedItem, Timer.Context> blocked = new WeakHashMap<Queue.BlockedItem, Timer.Context>();
        private final Map<Queue.BuildableItem, Timer.Context> buildable = new WeakHashMap<Queue.BuildableItem, Timer.Context>();
        private final Map<Queue.WaitingItem, Timer.Context> waiting = new WeakHashMap<Queue.WaitingItem, Timer.Context>();
        private final AtomicLong nextTrim = new AtomicLong(System.nanoTime());
        private final ConcurrentMap<Long, ItemTotals> totals = new ConcurrentHashMap<Long, ItemTotals>();
        private Set<Long> previousIds = new HashSet<Long>();

        public static ScheduledRate instance() {
            return (ScheduledRate)((Object)ExtensionList.lookup(QueueListener.class).get(ScheduledRate.class));
        }

        private void trim() {
            long next = this.nextTrim.get();
            if (next - System.nanoTime() < 0L && this.nextTrim.compareAndSet(next, next + TRIM_INTERVAL_NANOS)) {
                Queue queue = Jenkins.getInstance().getQueue();
                Set currentIds = Stream.concat(Stream.of(queue.getItems()), queue.getLeftItems().stream()).map(Queue.Item::getId).collect(Collectors.toCollection(HashSet::new));
                this.previousIds.removeAll(currentIds);
                this.totals.keySet().removeAll(this.previousIds);
                this.previousIds = currentIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAction(Run run) {
            TimeInQueueAction action;
            Executor executor = run.getExecutor();
            if (executor == null) {
                return;
            }
            WorkUnit workUnit = executor.getCurrentWorkUnit();
            if (workUnit == null) {
                return;
            }
            WorkUnitContext context = workUnit.context;
            if (context == null) {
                return;
            }
            Map<WorkUnitContext, TimeInQueueAction> map = this.actions;
            synchronized (map) {
                action = this.actions.remove(context);
            }
            if (action != null) {
                run.addAction((Action)action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLeft(Queue.LeftItem li) {
            long leftQueueAt = System.currentTimeMillis();
            long millisecondsInQueue = leftQueueAt - li.getInQueueSince();
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null && instance.jenkinsTaskQueueDuration != null) {
                instance.jenkinsTaskQueueDuration.update(millisecondsInQueue, TimeUnit.MILLISECONDS);
            }
            ItemTotals t = this.totals.getOrDefault(li.getId(), ItemTotals.EMPTY);
            Label assignedLabel = li.getAssignedLabel();
            WorkUnitContext wuc = li.outcome;
            if (wuc != null) {
                Queue.Task owner;
                Map<WorkUnitContext, TimeInQueueAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(wuc, new TimeInQueueAction(millisecondsInQueue, TimeUnit.NANOSECONDS.toMillis(t.blocked.get()), TimeUnit.NANOSECONDS.toMillis(t.buildable.get()), TimeUnit.NANOSECONDS.toMillis(t.waiting.get())));
                }
                for (owner = li.task.getOwnerTask(); owner != owner.getOwnerTask(); owner = owner.getOwnerTask()) {
                }
                boolean subTask = owner != li.task;
                CompletableFuture.supplyAsync(JenkinsMetricProviderImpl.asSupplier(wuc.future.getStartCondition()), this.executorService).thenAccept(executable -> {
                    long startTimeMillis = System.currentTimeMillis();
                    long queuingDurationMillis = startTimeMillis - li.getInQueueSince();
                    List<Set<LabelAtom>> consumedLabelAtoms = wuc.getWorkUnits().stream().map(w -> w == null ? null : w.getExecutor()).map(e -> e == null ? null : e.getOwner()).map(c -> c == null ? null : c.getNode()).map(n -> n == null ? Collections.emptySet() : n.getAssignedLabels()).collect(Collectors.toList());
                    QueueItemMetricsListener.notifyStarted(new QueueItemMetricsEvent((Queue.Item)li, assignedLabel, QueueItemMetricsEvent.State.STARTED, RunResolver.resolve(executable).orElse(null), (Queue.Executable)executable, consumedLabelAtoms, queuingDurationMillis, TimeUnit.NANOSECONDS.toMillis(t.waiting.get()), TimeUnit.NANOSECONDS.toMillis(t.blocked.get()), TimeUnit.NANOSECONDS.toMillis(t.buildable.get()), null, wuc.getWorkUnits().size()));
                    CompletableFuture.supplyAsync(JenkinsMetricProviderImpl.asSupplier((Future)wuc.future), this.executorService).thenRun(() -> {
                        long executionDurationMillis = System.currentTimeMillis() - startTimeMillis;
                        Optional<Run<?, ?>> run = RunResolver.resolve(executable);
                        if (subTask) {
                            run.ifPresent(r -> r.addAction((Action)new SubTaskTimeInQueueAction(queuingDurationMillis, TimeUnit.NANOSECONDS.toMillis(t.blocked.get()), TimeUnit.NANOSECONDS.toMillis(t.buildable.get()), TimeUnit.NANOSECONDS.toMillis(t.waiting.get()), executionDurationMillis, wuc.getWorkUnits().size())));
                        }
                        QueueItemMetricsListener.notifyFinished(new QueueItemMetricsEvent((Queue.Item)li, assignedLabel, QueueItemMetricsEvent.State.FINISHED, run.orElse(null), (Queue.Executable)executable, consumedLabelAtoms, queuingDurationMillis, TimeUnit.NANOSECONDS.toMillis(t.waiting.get()), TimeUnit.NANOSECONDS.toMillis(t.blocked.get()), TimeUnit.NANOSECONDS.toMillis(t.buildable.get()), executionDurationMillis, wuc.getWorkUnits().size()));
                        if (instance != null && instance.jenkinsTaskExecutionDuration != null) {
                            instance.jenkinsTaskExecutionDuration.update(executionDurationMillis, TimeUnit.MILLISECONDS);
                        }
                    });
                });
            } else {
                QueueItemMetricsEvent m = new QueueItemMetricsEvent((Queue.Item)li, assignedLabel, QueueItemMetricsEvent.State.CANCELLED, null, null, null, System.currentTimeMillis() - li.getInQueueSince(), TimeUnit.NANOSECONDS.toMillis(t.blocked.get()), TimeUnit.NANOSECONDS.toMillis(t.buildable.get()), TimeUnit.NANOSECONDS.toMillis(t.waiting.get()), null, null);
                this.executorService.submit(() -> QueueItemMetricsListener.notifyCancelled(m));
            }
            this.totals.remove(li.getId());
            this.trim();
        }

        private void checkEnterQueue(Queue.Item i) {
            this.totals.computeIfAbsent(i.getId(), id -> {
                QueueItemMetricsEvent m = new QueueItemMetricsEvent(i, i.getAssignedLabel(), QueueItemMetricsEvent.State.QUEUED, null, null, null, null, null, null, null, null, null);
                this.executorService.submit(() -> QueueItemMetricsListener.notifyQueued(m));
                return new ItemTotals((Long)id);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnterBlocked(Queue.BlockedItem bi) {
            this.checkEnterQueue((Queue.Item)bi);
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null && instance.jenkinsTaskBlockedDuration != null) {
                Map<Queue.BlockedItem, Timer.Context> map = this.blocked;
                synchronized (map) {
                    if (!this.blocked.containsKey(bi)) {
                        this.blocked.put(bi, instance.jenkinsTaskBlockedDuration.time());
                    }
                }
            }
            this.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLeaveBlocked(Queue.BlockedItem bi) {
            Map<Queue.BlockedItem, Timer.Context> map = this.blocked;
            synchronized (map) {
                Timer.Context context = this.blocked.remove(bi);
                if (context != null) {
                    this.totals.computeIfAbsent(bi.getId(), x$0 -> new ItemTotals((Long)x$0)).blocked.getAndAdd(context.stop());
                }
            }
            this.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnterBuildable(Queue.BuildableItem bi) {
            this.checkEnterQueue((Queue.Item)bi);
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null && instance.jenkinsTaskBuildableDuration != null) {
                Map<Queue.BuildableItem, Timer.Context> map = this.buildable;
                synchronized (map) {
                    this.buildable.computeIfAbsent(bi, x -> instance.jenkinsTaskBuildableDuration.time());
                }
            }
            this.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLeaveBuildable(Queue.BuildableItem bi) {
            Map<Queue.BuildableItem, Timer.Context> map = this.buildable;
            synchronized (map) {
                Timer.Context context = this.buildable.remove(bi);
                if (context != null) {
                    this.totals.computeIfAbsent(bi.getId(), x$0 -> new ItemTotals((Long)x$0)).buildable.getAndAdd(context.stop());
                }
            }
            this.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnterWaiting(Queue.WaitingItem wi) {
            this.checkEnterQueue((Queue.Item)wi);
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null && instance.jenkinsTaskWaitingDuration != null) {
                Map<Queue.WaitingItem, Timer.Context> map = this.waiting;
                synchronized (map) {
                    this.waiting.computeIfAbsent(wi, x -> instance.jenkinsTaskWaitingDuration.time());
                }
            }
            this.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLeaveWaiting(Queue.WaitingItem wi) {
            Map<Queue.WaitingItem, Timer.Context> map = this.waiting;
            synchronized (map) {
                Timer.Context context = this.waiting.remove(wi);
                if (context != null) {
                    this.totals.computeIfAbsent(wi.getId(), x$0 -> new ItemTotals((Long)x$0)).waiting.getAndAdd(context.stop());
                }
            }
            this.trim();
        }

        private static class ItemTotals {
            private static final ItemTotals EMPTY = new ItemTotals(null);
            private final AtomicLong blocked = new AtomicLong();
            private final AtomicLong buildable = new AtomicLong();
            private final AtomicLong waiting = new AtomicLong();

            private ItemTotals(Long ignore) {
            }

            public String toString() {
                return "ItemTotals{blocked=" + Util.getTimeSpanString((long)TimeUnit.NANOSECONDS.toMillis(this.blocked.get())) + ", buildable=" + Util.getTimeSpanString((long)TimeUnit.NANOSECONDS.toMillis(this.buildable.get())) + ", waiting=" + Util.getTimeSpanString((long)TimeUnit.NANOSECONDS.toMillis(this.waiting.get())) + '}';
            }
        }
    }

    @Extension(ordinal=1.7976931348623157E308)
    public static class SchedulingRate
    extends Queue.QueueDecisionHandler {
        public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null) {
                if (p instanceof Job && instance.jenkinsJobScheduleRate != null) {
                    instance.jenkinsJobScheduleRate.mark();
                }
                if (instance.jenkinsTaskScheduleRate != null) {
                    instance.jenkinsTaskScheduleRate.mark();
                }
            }
            return true;
        }
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        private Map<Run, List<Timer.Context>> contexts = new HashMap<Run, List<Timer.Context>>();

        public synchronized void onStarted(Run run, TaskListener listener) {
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null) {
                ArrayList<Timer.Context> contextList = new ArrayList<Timer.Context>();
                contextList.add(instance.jenkinsJobBuildingDuration.time());
                Executor executor = run.getExecutor();
                if (executor != null) {
                    Computer computer = executor.getOwner();
                    Timer timer = instance.getOrCreateTimer(computer);
                    contextList.add(timer.time());
                }
                this.contexts.put(run, contextList);
            }
            ScheduledRate.instance().addAction(run);
        }

        public synchronized void onCompleted(Run run, TaskListener listener) {
            List<Timer.Context> contextList = this.contexts.remove(run);
            if (contextList != null) {
                for (Timer.Context context : contextList) {
                    context.stop();
                }
            }
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            TimeInQueueAction action = (TimeInQueueAction)run.getAction(TimeInQueueAction.class);
            if (action != null && instance != null) {
                if (instance.jenkinsJobQueueDuration != null) {
                    instance.jenkinsJobQueueDuration.update(action.getQueuingTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (instance.jenkinsJobBlockedDuration != null) {
                    instance.jenkinsJobBlockedDuration.update(action.getBlockedTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (instance.jenkinsJobBuildableDuration != null) {
                    instance.jenkinsJobBuildableDuration.update(action.getBuildableTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (instance.jenkinsJobWaitingDuration != null) {
                    instance.jenkinsJobWaitingDuration.update(action.getWaitingTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (instance.jenkinsJobTotalDuration != null) {
                    instance.jenkinsJobTotalDuration.update(action.getTotalDurationMillis(), TimeUnit.MILLISECONDS);
                }
                if (instance.jenkinsJobExecutionTime != null) {
                    instance.jenkinsJobExecutionTime.update(action.getExecutingTimeMillis(), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    @Extension
    public static class ResultRunListener
    extends RunListener<Run> {
        static final String[] ALL = new String[]{"success", "unstable", "failure", "not_built", "aborted", "total"};

        public synchronized void onCompleted(Run run, TaskListener listener) {
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance != null) {
                ((Meter)instance.jenkinsRunResults.get(String.valueOf(run.getResult()).toLowerCase(Locale.ENGLISH))).mark();
                ((Meter)instance.jenkinsRunResults.get("total")).mark();
            }
        }
    }

    @Extension
    public static class PeriodicWorkImpl
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(5L);
        }

        protected synchronized void doRun() {
            JenkinsMetricProviderImpl instance = JenkinsMetricProviderImpl.instance();
            if (instance == null) {
                return;
            }
            instance.updateMetrics();
        }

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        @Restricted(value={DoNotUse.class})
        public static void dynamicInstallHack() {
            PeriodicWork p;
            VersionNumber version;
            if (Jenkins.getInstance().getInitLevel() == InitMilestone.COMPLETED && (version = Jenkins.getVersion()) != null && version.isOlderThan(new VersionNumber("2.129")) && (p = (PeriodicWork)ExtensionList.lookup(PeriodicWork.class).get(PeriodicWorkImpl.class)) != null) {
                jenkins.util.Timer.get().scheduleAtFixedRate((Runnable)p, p.getInitialDelay(), p.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private static class JobStats {
        private final int jobCount;
        private final int disabledProjectCount;
        private final int projectCount;
        private final double depthAverage;

        public JobStats(int jobCount, int projectCount, int disabledProjectCount, double depthAverage) {
            this.jobCount = jobCount;
            this.disabledProjectCount = disabledProjectCount;
            this.projectCount = projectCount;
            this.depthAverage = depthAverage;
        }

        public int getJobCount() {
            return this.jobCount;
        }

        public int getDisabledProjectCount() {
            return this.disabledProjectCount;
        }

        public int getProjectCount() {
            return this.projectCount;
        }

        public Integer getEnabledProjectCount() {
            return this.projectCount - this.disabledProjectCount;
        }

        public double getDepthAverage() {
            return this.depthAverage;
        }
    }

    private static class NodeStats {
        private final int nodeCount;
        private final int nodeOnline;
        private final int executorCount;
        private final int executorBuilding;

        public NodeStats(int nodeCount, int nodeOnline, int executorCount, int executorBuilding) {
            this.nodeCount = nodeCount;
            this.nodeOnline = nodeOnline;
            this.executorCount = executorCount;
            this.executorBuilding = executorBuilding;
        }

        public int getExecutorAvailable() {
            return this.executorCount - this.executorBuilding;
        }

        public int getExecutorBuilding() {
            return this.executorBuilding;
        }

        public int getExecutorCount() {
            return this.executorCount;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getNodeOffline() {
            return this.nodeCount - this.nodeOnline;
        }

        public int getNodeOnline() {
            return this.nodeOnline;
        }
    }

    private static class QueueStats {
        private final int length;
        private final int blocked;
        private final int buildable;
        private final int stuck;
        private final int pending;

        public QueueStats(int length, int blocked, int buildable, int pending, int stuck) {
            this.length = length;
            this.blocked = blocked;
            this.buildable = buildable;
            this.pending = pending;
            this.stuck = stuck;
        }

        public int getBlocked() {
            return this.blocked;
        }

        public int getBuildable() {
            return this.buildable;
        }

        public int getLength() {
            return this.length;
        }

        public int getPending() {
            return this.pending;
        }

        public int getStuck() {
            return this.stuck;
        }
    }
}

