/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

@Extension
public class BuildTriggerListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        StepContext stepContext;
        BuildTriggerAction buildTriggerAction = (BuildTriggerAction)run.getAction(BuildTriggerAction.class);
        if (buildTriggerAction != null && (stepContext = buildTriggerAction.getStepContext()) != null && stepContext.isReady()) {
            try {
                TaskListener taskListener = (TaskListener)stepContext.get(TaskListener.class);
                taskListener.getLogger().println("Starting building: " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }
    }

    public void onCompleted(Run<?, ?> run, @Nonnull TaskListener listener) {
        List actions = run.getActions(BuildTriggerAction.class);
        for (BuildTriggerAction action : actions) {
            if (!action.isPropagate() || run.getResult() == Result.SUCCESS) {
                action.getStepContext().onSuccess((Object)new RunWrapper(run, false));
                continue;
            }
            action.getStepContext().onFailure((Throwable)new AbortException(run.getFullDisplayName() + " completed with status " + run.getResult() + " (propagate: false to ignore)"));
        }
        run.getActions().removeAll(actions);
    }

    public void onDeleted(Run<?, ?> run) {
        for (BuildTriggerAction action : run.getActions(BuildTriggerAction.class)) {
            action.getStepContext().onFailure((Throwable)new AbortException(run.getFullDisplayName() + " was deleted"));
        }
    }
}

