/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerCancelledCause;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStep;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;

public class BuildTriggerStepExecution
extends AbstractStepExecutionImpl {
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient Run<?, ?> invokingRun;
    @StepContextParameter
    private transient FlowNode node;
    @Inject(optional=true)
    transient BuildTriggerStep step;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        QueueTaskFuture f;
        Integer quietPeriod;
        String job = this.step.getJob();
        final ParameterizedJobMixIn.ParameterizedJob project = (ParameterizedJobMixIn.ParameterizedJob)Jenkins.getActiveInstance().getItem(job, (Item)this.invokingRun.getParent(), ParameterizedJobMixIn.ParameterizedJob.class);
        if (project == null) {
            throw new AbortException("No parameterized job named " + job + " found");
        }
        this.listener.getLogger().println("Scheduling project: " + ModelHyperlinkNote.encodeTo((Item)project));
        this.node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_building_(project.getFullDisplayName())));
        ArrayList<BuildTriggerAction> actions = new ArrayList<BuildTriggerAction>();
        if (this.step.getWait()) {
            actions.add(new BuildTriggerAction(this.getContext(), this.step.isPropagate()));
        }
        actions.add((BuildTriggerAction)new CauseAction((Cause)new Cause.UpstreamCause(this.invokingRun)));
        List<ParameterValue> parameters = this.step.getParameters();
        if (parameters != null) {
            parameters = this.completeDefaultParameters(parameters, (Job)project);
            actions.add((BuildTriggerAction)new ParametersAction(parameters));
        }
        if ((quietPeriod = this.step.getQuietPeriod()) == null) {
            quietPeriod = project.getQuietPeriod();
        }
        if ((f = new ParameterizedJobMixIn(){

            protected Job asJob() {
                return (Job)project;
            }
        }.scheduleBuild2(quietPeriod.intValue(), actions.toArray(new Action[actions.size()]))) == null) {
            throw new AbortException("Failed to trigger build of " + project.getFullName());
        }
        if (this.step.getWait()) {
            return false;
        }
        this.getContext().onSuccess(null);
        return true;
    }

    private List<ParameterValue> completeDefaultParameters(List<ParameterValue> parameters, Job<?, ?> project) {
        ParametersDefinitionProperty pdp;
        ArrayList completeListOfParameters = Lists.newArrayList(parameters);
        List names = Lists.transform(parameters, (Function)new Function<ParameterValue, String>(){

            public String apply(ParameterValue input) {
                return input.getName();
            }
        });
        if (project != null && (pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class)) != null) {
            for (ParameterDefinition pDef : pdp.getParameterDefinitions()) {
                ParameterValue defaultP;
                if (names.contains(pDef.getName()) || (defaultP = pDef.getDefaultParameterValue()) == null) continue;
                completeListOfParameters.add(defaultP);
            }
        }
        return completeListOfParameters;
    }

    public void stop(Throwable cause) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return;
        }
        Queue q = jenkins.getQueue();
        for (Queue.Item item : q.getItems()) {
            for (BuildTriggerAction bta : item.getActions(BuildTriggerAction.class)) {
                if (!bta.getStepContext().equals((Object)this.getContext())) continue;
                q.cancel(item);
            }
        }
        for (Queue.Item item : jenkins.getComputers()) {
            for (Executor e : item.getExecutors()) {
                this.maybeInterrupt(e, cause);
            }
            for (Executor e : item.getOneOffExecutors()) {
                this.maybeInterrupt(e, cause);
            }
        }
    }

    private void maybeInterrupt(Executor e, Throwable cause) {
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            for (BuildTriggerAction bta : ((Run)exec).getActions(BuildTriggerAction.class)) {
                if (!bta.getStepContext().equals((Object)this.getContext())) continue;
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new BuildTriggerCancelledCause(cause)});
            }
        }
    }

    public String getStatus() {
        for (Queue.Item item : Queue.getInstance().getItems()) {
            for (BuildTriggerAction bta : item.getActions(BuildTriggerAction.class)) {
                if (!bta.getStepContext().equals((Object)this.getContext())) continue;
                return "waiting to schedule " + item.task.getFullDisplayName() + "; blocked: " + item.getWhy();
            }
        }
        for (Queue.Item item : Jenkins.getActiveInstance().getComputers()) {
            String r;
            for (Executor e : item.getExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
            for (Executor e : item.getOneOffExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
        }
        return "unsure what happened to downstream build";
    }

    @CheckForNull
    private String running(@Nonnull Executor e) {
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            Run run = (Run)exec;
            for (BuildTriggerAction bta : run.getActions(BuildTriggerAction.class)) {
                if (!bta.getStepContext().equals((Object)this.getContext())) continue;
                return "running " + run;
            }
        }
        return null;
    }
}

