/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Describable;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.queue.ScheduleResult;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerCancelledCause;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStep;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamCause;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamNodeAction;
import org.jenkinsci.plugins.workflow.support.steps.build.DownstreamBuildAction;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;

public class BuildTriggerStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerStepExecution.class.getName());
    private static final Set<String> CHOICE_PARAMETER_DEFINITION_LIKE_CLASSES = ImmutableSet.of((Object)"jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition", (Object)"org.biouno.unochoice.CascadeChoiceParameter", (Object)"org.biouno.unochoice.ChoiceParameter", (Object)"org.biouno.unochoice.DynamicReferenceParameter");
    private final transient BuildTriggerStep step;
    private static final long serialVersionUID = 1L;

    public BuildTriggerStepExecution(BuildTriggerStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        String job = this.step.getJob();
        Run upstream = (Run)this.getContext().get(Run.class);
        Item item = Jenkins.get().getItem(job, (Item)upstream.getParent(), Item.class);
        if (item == null) {
            throw new AbortException("No item named " + job + " found");
        }
        item.checkPermission(Item.BUILD);
        if ((this.step.getWait() || this.step.getWaitForStart()) && !(item instanceof Job)) {
            throw new AbortException("Waiting for non-job items is not supported");
        }
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        DownstreamBuildAction.getOrCreate(upstream, node.getId(), item);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new CauseAction((Cause)new BuildUpstreamCause((FlowNode)this.getContext().get(FlowNode.class), upstream)));
        actions.add((Object)new BuildUpstreamNodeAction(node, upstream));
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            int quietPeriod;
            Queue.Item queueItem;
            List<ParameterValue> parameters;
            ParameterizedJobMixIn.ParameterizedJob project = (ParameterizedJobMixIn.ParameterizedJob)item;
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Scheduling project: " + ModelHyperlinkNote.encodeTo((Item)project));
            if (!this.step.getWait() || this.step.getWaitForStart()) {
                node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_scheduling(project.getFullDisplayName())));
            } else {
                node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_building_(project.getFullDisplayName())));
            }
            if (this.step.getWait() || this.step.getWaitForStart()) {
                StepContext context = this.getContext();
                actions.add((Object)new BuildTriggerAction(context, this.step.isPropagate(), this.step.getWaitForStart()));
                LOGGER.log(Level.FINER, "scheduling a build of {0} from {1}", new Object[]{project, context});
            }
            if ((parameters = this.step.getParameters()) != null) {
                parameters = this.completeDefaultParameters(parameters, (Job)project);
                actions.add(new ParametersAction(parameters));
            }
            if ((queueItem = ParameterizedJobMixIn.scheduleBuild2((Job)((Job)project), (int)(quietPeriod = this.step.getQuietPeriod() != null ? this.step.getQuietPeriod() : -1), (Action[])actions.toArray(new Action[0]))) == null || queueItem.getFuture() == null) {
                throw new AbortException("Failed to trigger build of " + project.getFullName());
            }
        } else if (item instanceof Queue.Task) {
            ScheduleResult scheduleResult;
            Integer quietPeriod;
            if (this.step.getParameters() != null && !this.step.getParameters().isEmpty()) {
                throw new AbortException("Item type does not support parameters");
            }
            Queue.Task task = (Queue.Task)item;
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Scheduling item: " + ModelHyperlinkNote.encodeTo((Item)item));
            if (!this.step.getWait() || this.step.getWaitForStart()) {
                node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_scheduling(task.getFullDisplayName())));
            } else {
                node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_building_(task.getFullDisplayName())));
            }
            if (this.step.getWait() || this.step.getWaitForStart()) {
                StepContext context = this.getContext();
                actions.add((Object)new BuildTriggerAction(context, this.step.isPropagate(), this.step.getWaitForStart()));
                LOGGER.log(Level.FINER, "scheduling a build of {0} from {1}", new Object[]{task, context});
            }
            if ((quietPeriod = this.step.getQuietPeriod()) == null) {
                try {
                    Method getQuietPeriod = task.getClass().getMethod("getQuietPeriod", new Class[0]);
                    if (getQuietPeriod.getReturnType().equals(Integer.TYPE)) {
                        quietPeriod = (Integer)getQuietPeriod.invoke((Object)task, new Object[0]);
                    }
                }
                catch (NoSuchMethodException getQuietPeriod) {
                }
                catch (IllegalAccessError | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.log(Level.WARNING, "Could not determine quiet period of " + item.getFullName(), e);
                }
            }
            if (quietPeriod == null) {
                quietPeriod = Jenkins.get().getQuietPeriod();
            }
            if ((scheduleResult = Jenkins.get().getQueue().schedule2(task, quietPeriod.intValue(), actions)).isRefused()) {
                throw new AbortException("Failed to trigger build of " + item.getFullName());
            }
        } else {
            throw new AbortException("The item named " + job + " is a " + (item instanceof Describable ? ((Describable)item).getDescriptor().getDisplayName() : item.getClass().getName()) + " which is not something that can be built");
        }
        if (this.step.getWait() || this.step.getWaitForStart()) {
            return false;
        }
        this.getContext().onSuccess(null);
        return true;
    }

    private List<ParameterValue> completeDefaultParameters(List<ParameterValue> parameters, Job<?, ?> project) throws IOException, InterruptedException {
        ParametersDefinitionProperty pdp;
        LinkedHashMap<String, ParameterValue> allParameters = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue pv : parameters) {
            allParameters.put(pv.getName(), pv);
        }
        if (project != null && (pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class)) != null) {
            for (ParameterDefinition pDef : pdp.getParameterDefinitions()) {
                ParameterValue pv;
                if (!allParameters.containsKey(pDef.getName())) {
                    ParameterValue defaultP = pDef.getDefaultParameterValue();
                    if (defaultP == null) continue;
                    allParameters.put(defaultP.getName(), defaultP);
                    continue;
                }
                String description = Util.fixNull((String)pDef.getDescription());
                if (pDef instanceof SimpleParameterDefinition && !(pDef instanceof StringParameterDefinition) && !(pDef instanceof ChoiceParameterDefinition) && (pv = (ParameterValue)allParameters.get(pDef.getName())) instanceof StringParameterValue) {
                    String pDefDisplayName = pDef.getDescriptor().getDisplayName();
                    if (!CHOICE_PARAMETER_DEFINITION_LIKE_CLASSES.contains(pDef.getClass().getName())) {
                        ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().printf("The parameter '%s' did not have the type expected by %s. Converting to %s.%n", pv.getName(), ModelHyperlinkNote.encodeTo(project), pDefDisplayName);
                        description = Messages.BuildTriggerStepExecution_convertedParameterDescription(description, pDefDisplayName, ((Run)this.getContext().get(Run.class)).toString());
                    }
                    ParameterValue convertedValue = ((SimpleParameterDefinition)pDef).createValue((String)pv.getValue());
                    allParameters.put(pDef.getName(), convertedValue);
                }
                if (!pDef.isValid(pv = (ParameterValue)allParameters.get(pDef.getName()))) {
                    throw new AbortException("Invalid parameter value: " + String.valueOf(pv));
                }
                ((ParameterValue)allParameters.get(pDef.getName())).setDescription(description);
            }
        }
        return Lists.newArrayList(allParameters.values());
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        StepContext context = this.getContext();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            context.onFailure(cause);
            return;
        }
        boolean interrupted = false;
        Queue q = jenkins.getQueue();
        for (Queue.Item item : q.getItems()) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)item)) {
                if (!trigger.context.equals((Object)context)) continue;
                q.cancel(item);
                interrupted = true;
            }
        }
        for (Queue.Item item : jenkins.getComputers()) {
            for (Executor e : item.getExecutors()) {
                interrupted |= BuildTriggerStepExecution.maybeInterrupt(e, cause, context);
            }
            for (Executor e : item.getOneOffExecutors()) {
                interrupted |= BuildTriggerStepExecution.maybeInterrupt(e, cause, context);
            }
        }
        if (!interrupted) {
            super.stop(cause);
        }
    }

    private static boolean maybeInterrupt(Executor e, Throwable cause, StepContext context) {
        boolean interrupted = false;
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)((Run)exec))) {
                if (!trigger.context.equals((Object)context)) continue;
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new BuildTriggerCancelledCause(cause)});
                trigger.interruption = cause;
                try {
                    ((Run)exec).save();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to save interrupt cause on " + String.valueOf(exec), x);
                }
                interrupted = true;
            }
        }
        return interrupted;
    }

    public String getStatus() {
        for (Queue.Item item : Queue.getInstance().getItems()) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)item)) {
                if (!trigger.context.equals((Object)this.getContext())) continue;
                return "waiting to schedule " + item.task.getFullDisplayName() + "; blocked: " + item.getWhy();
            }
        }
        for (Queue.Item item : Jenkins.get().getComputers()) {
            String r;
            for (Executor e : item.getExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
            for (Executor e : item.getOneOffExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
        }
        return "unsure what happened to downstream build";
    }

    @CheckForNull
    private String running(@NonNull Executor e) {
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            Run run = (Run)exec;
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)run)) {
                if (!trigger.context.equals((Object)this.getContext())) continue;
                return "running " + String.valueOf(run);
            }
        }
        return null;
    }
}

