/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.pipelinegraphanalysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;

public class StageChunkFinder
implements ChunkFinder {
    public boolean isStartInsideChunk() {
        return true;
    }

    public boolean isChunkStart(@NonNull FlowNode current, @CheckForNull FlowNode previous) {
        if ((current instanceof StepAtomNode || current instanceof StepStartNode) && !(((StepNode)current).getDescriptor() instanceof StageStep.DescriptorImpl)) {
            return false;
        }
        if (current instanceof BlockEndNode) {
            return false;
        }
        if (current instanceof StepStartNode) {
            StepStartNode startNode = (StepStartNode)current;
            if (!(startNode.getDescriptor() instanceof StageStep.DescriptorImpl)) {
                return false;
            }
            return startNode.getAction(LabelAction.class) != null;
        }
        return current.getAction(StageAction.class) != null;
    }

    public boolean isChunkEnd(@NonNull FlowNode current, @CheckForNull FlowNode previous) {
        if (current instanceof StepEndNode && ((StepEndNode)current).getDescriptor() instanceof StageStep.DescriptorImpl) {
            return ((StepStartNode)((StepEndNode)current).getStartNode()).getAction(LabelAction.class) != null;
        }
        if (previous != null) {
            return this.isChunkStart(previous, null);
        }
        return false;
    }
}

