/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.RunAction2;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;

public class InputAction
implements RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(InputAction.class.getName());
    private static int LOAD_EXECUTIONS_TIMEOUT = Integer.getInteger(InputAction.class.getName() + ".LOAD_EXECUTIONS_TIMEOUT", 10);
    private transient List<InputStepExecution> executions = new ArrayList<InputStepExecution>();
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="CopyOnWriteArrayList")
    private List<String> ids = new CopyOnWriteArrayList<String>();
    private transient Run<?, ?> run;

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(Run<?, ?> r) {
        this.run = r;
        InputAction inputAction = this;
        synchronized (inputAction) {
            if (this.ids == null) {
                assert (this.executions != null && !this.executions.contains(null)) : this.executions;
                this.ids = new ArrayList<String>();
                for (InputStepExecution execution : this.executions) {
                    this.ids.add(execution.getId());
                }
                this.executions = null;
            }
        }
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"}, justification="WorkflowRun implements Queue.Executable")
    private synchronized void loadExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList<InputStepExecution>();
            try {
                FlowExecution execution = null;
                for (FlowExecution _execution : FlowExecutionList.get()) {
                    if (_execution.getOwner().getExecutable() != this.run) continue;
                    execution = _execution;
                    break;
                }
                if (execution != null) {
                    for (StepExecution se : (List)execution.getCurrentExecutions(true).get((long)LOAD_EXECUTIONS_TIMEOUT, TimeUnit.SECONDS)) {
                        InputStepExecution ise;
                        if (!(se instanceof InputStepExecution) || !this.ids.contains((ise = (InputStepExecution)se).getId())) continue;
                        this.executions.add(ise);
                    }
                    if (this.executions.size() < this.ids.size()) {
                        LOGGER.log(Level.WARNING, "some input IDs not restored from {0}", this.run);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "no flow execution found for {0}", this.run);
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getIconFileName() {
        if (this.ids == null || this.ids.isEmpty()) {
            return null;
        }
        return "help.png";
    }

    public String getDisplayName() {
        if (this.ids == null || this.ids.isEmpty()) {
            return null;
        }
        return "Paused for Input";
    }

    public String getUrlName() {
        return "input";
    }

    public synchronized void add(@Nonnull InputStepExecution step) throws IOException {
        this.loadExecutions();
        this.executions.add(step);
        this.ids.add(step.getId());
        this.run.save();
    }

    public synchronized InputStepExecution getExecution(String id) {
        this.loadExecutions();
        for (InputStepExecution e : this.executions) {
            if (!e.input.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    public synchronized List<InputStepExecution> getExecutions() {
        this.loadExecutions();
        return new ArrayList<InputStepExecution>(this.executions);
    }

    public synchronized void remove(InputStepExecution exec) throws IOException {
        this.loadExecutions();
        this.executions.remove((Object)exec);
        this.ids.remove(exec.getId());
        this.run.save();
    }

    public InputStepExecution getDynamic(String token) {
        return this.getExecution(token);
    }
}

