/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.User;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.support.steps.input.Messages;
import org.kohsuke.stapler.export.Exported;

public final class Rejection
extends CauseOfInterruption {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final String userName;
    private final long timestamp;

    public Rejection(@CheckForNull User u) {
        this.userName = u == null ? null : u.getId();
        this.timestamp = System.currentTimeMillis();
    }

    @Exported
    @CheckForNull
    public User getUser() {
        return this.userName != null ? User.get((String)this.userName) : null;
    }

    @Exported
    public long getTimestamp() {
        return this.timestamp;
    }

    public String getShortDescription() {
        User u = this.getUser();
        if (u != null) {
            return Messages.rejected_by(u.getDisplayName());
        }
        return Messages.rejected();
    }
}

