/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.workflow.steps.StepContext;

class Milestone {
    final Integer ordinal;
    final Set<Integer> inSight = new TreeSet<Integer>();
    @CheckForNull
    Integer lastBuild;

    Milestone(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public String toString() {
        return "Milestone[inSight=" + this.inSight + "]";
    }

    public void pass(StepContext context, Run<?, ?> build) {
        this.lastBuild = build.getNumber();
        this.inSight.add(build.getNumber());
    }

    public boolean wentAway(Run<?, ?> build) {
        if (this.inSight.contains(build.getNumber())) {
            this.inSight.remove(build.getNumber());
            return true;
        }
        return false;
    }
}

