/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.milestone.Milestone;
import org.jenkinsci.plugins.pipeline.milestone.MilestoneStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MilestoneStep
extends AbstractStepImpl {
    private String label;
    private Integer ordinal;
    private boolean unsafe;

    @DataBoundConstructor
    public MilestoneStep(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = Util.fixEmpty((String)label);
    }

    @DataBoundSetter
    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    @CheckForNull
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        private Map<String, Map<Integer, Milestone>> milestonesByOrdinalByJob;
        private static final Logger LOGGER = Logger.getLogger(MilestoneStep.class.getName());

        public DescriptorImpl() {
            super(MilestoneStepExecution.class);
            this.load();
        }

        public String getFunctionName() {
            return "milestone";
        }

        public String getDisplayName() {
            return "The milestone step forces all builds to go through in order";
        }

        public void load() {
            super.load();
            if (this.milestonesByOrdinalByJob == null) {
                this.milestonesByOrdinalByJob = new TreeMap<String, Map<Integer, Milestone>>();
            }
            LOGGER.log(Level.FINE, "load: {0}", this.milestonesByOrdinalByJob);
        }

        public void save() {
            super.save();
            LOGGER.log(Level.FINE, "save: {0}", this.milestonesByOrdinalByJob);
        }

        public Map<String, Map<Integer, Milestone>> getMilestonesByOrdinalByJob() {
            return this.milestonesByOrdinalByJob;
        }
    }
}

