/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub.listeners;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import hudson.model.queue.QueueTaskFuture;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.Events;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.QueueTaskMessage;

@Extension
public class SyncQueueListener
extends QueueListener {
    private static final Logger LOGGER = Logger.getLogger(SyncQueueListener.class.getName());
    private static final BlockingQueue<Queue.LeftItem> queueTaskLeftPublishQueue = new LinkedBlockingQueue<Queue.LeftItem>();
    private static final BlockingQueue<Queue.LeftItem> tryLaterQueueTaskLeftQueue = new LinkedBlockingQueue<Queue.LeftItem>();
    private static volatile boolean stopTaskLeftPublishing = false;
    private static final long POLL_TIMEOUT_MILLIS = 1000L;

    public static void shutdown() {
        stopTaskLeftPublishing = true;
    }

    public void onEnterWaiting(Queue.WaitingItem wi) {
        this.publish((Queue.Item)wi, Events.JobChannel.job_run_queue_enter);
    }

    public void onEnterBuildable(Queue.BuildableItem bi) {
        this.publish((Queue.Item)bi, Events.JobChannel.job_run_queue_buildable);
    }

    public void onLeft(Queue.LeftItem li) {
        if (li.isCancelled()) {
            SyncQueueListener.publish((Queue.Item)li, Events.JobChannel.job_run_queue_left, "CANCELLED");
        } else {
            SyncQueueListener.publish((Queue.Item)li, Events.JobChannel.job_run_queue_left, "ALLOCATED");
            if (!stopTaskLeftPublishing) {
                try {
                    queueTaskLeftPublishQueue.put(li);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Error publishing job_run_queue_task_complete event.", e);
                }
            }
        }
    }

    public void onEnterBlocked(Queue.BlockedItem bi) {
        this.publish((Queue.Item)bi, Events.JobChannel.job_run_queue_blocked);
    }

    private void publish(Queue.Item item, Events.JobChannel event) {
        SyncQueueListener.publish(item, event, "QUEUED");
    }

    private static void publish(Queue.Item item, Events.JobChannel event, String status) {
        Queue.Task task = item.task;
        if (task instanceof Item) {
            try {
                PubsubBus.getBus().publish((Message)((Message)((Message)new QueueTaskMessage(item, (Item)task).setEventName(event)).set(EventProps.Job.job_run_queueId, Long.toString(item.getId()))).set(EventProps.Job.job_run_status, status));
            }
            catch (MessageException e) {
                LOGGER.log(Level.WARNING, "Error publishing Run queued event.", e);
            }
        }
    }

    static {
        new Thread(() -> {
            try {
                while (!stopTaskLeftPublishing) {
                    try {
                        Queue.LeftItem leftItem = queueTaskLeftPublishQueue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (leftItem != null) {
                            QueueTaskFuture future = leftItem.getFuture();
                            if (future.isDone()) {
                                tryLaterQueueTaskLeftQueue.drainTo(queueTaskLeftPublishQueue);
                                SyncQueueListener.publish((Queue.Item)leftItem, Events.JobChannel.job_run_queue_task_complete, null);
                                continue;
                            }
                            if (Queue.getInstance().getItem(leftItem.getId()) == null) continue;
                            tryLaterQueueTaskLeftQueue.put(leftItem);
                            continue;
                        }
                        tryLaterQueueTaskLeftQueue.drainTo(queueTaskLeftPublishQueue);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Error publishing job_run_queue_task_complete event.", e);
                    }
                }
                return;
            }
            finally {
                queueTaskLeftPublishQueue.clear();
                tryLaterQueueTaskLeftQueue.clear();
            }
        }, "SyncQueueListener").start();
    }
}

