/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import jenkins.model.Jenkins;
import org.apache.commons.lang.NotImplementedException;
import org.jenkinsci.plugins.saml.SamlAdvancedConfiguration;
import org.jenkinsci.plugins.saml.SamlFileResourceCache;
import org.jenkinsci.plugins.saml.SamlFileResourceDisk;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

class SamlFileResource
implements WritableResource {
    private final WritableResource resource;

    public SamlFileResource(@NonNull String fileName) {
        this.resource = this.getUseDiskCache() ? new SamlFileResourceCache(fileName) : new SamlFileResourceDisk(fileName);
    }

    public SamlFileResource(@NonNull String fileName, @NonNull String data) {
        this.resource = this.getUseDiskCache() ? new SamlFileResourceCache(fileName, data) : new SamlFileResourceDisk(fileName, data);
    }

    private boolean getUseDiskCache() {
        SamlSecurityRealm samlSecurityRealm;
        SamlAdvancedConfiguration config;
        boolean ret = false;
        Jenkins j = Jenkins.get();
        if (j.getSecurityRealm() instanceof SamlSecurityRealm && (config = (samlSecurityRealm = (SamlSecurityRealm)j.getSecurityRealm()).getAdvancedConfiguration()) != null) {
            ret = config.getUseDiskCache();
        }
        return ret;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isReadable() {
        return this.resource.isReadable();
    }

    public boolean isOpen() {
        return false;
    }

    @NonNull
    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    @NonNull
    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    @NonNull
    public String getDescription() {
        return this.resource.getDescription();
    }

    @NonNull
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @NonNull
    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    @NonNull
    public Resource createRelative(@NonNull String s) {
        throw new NotImplementedException();
    }

    public boolean isWritable() {
        return this.resource.isWritable();
    }

    @NonNull
    public OutputStream getOutputStream() throws IOException {
        return this.resource.getOutputStream();
    }
}

