/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class SCMSourceDescriptor
extends Descriptor<SCMSource> {
    @NonNull
    public String getId(@CheckForNull SCMSource source) {
        return source == null ? UUID.randomUUID().toString() : source.getId();
    }

    public boolean isApplicable(Class<? extends SCMSourceOwner> owner) {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isUserInstantiable() {
        return true;
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(@CheckForNull SCMSourceOwner owner) {
        return SCMSourceDescriptor.forOwner(owner == null ? SCMSourceOwner.class : owner.getClass(), true);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(@CheckForNull SCMSourceOwner owner, boolean onlyUserInstantiable) {
        return SCMSourceDescriptor.forOwner(owner == null ? SCMSourceOwner.class : owner.getClass(), onlyUserInstantiable);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(Class<? extends SCMSourceOwner> clazz) {
        return SCMSourceDescriptor.forOwner(clazz, true);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(Class<? extends SCMSourceOwner> clazz, boolean onlyUserInstantiable) {
        ArrayList<SCMSourceDescriptor> result = new ArrayList<SCMSourceDescriptor>();
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return result;
        }
        for (Descriptor d : j.getDescriptorList(SCMSource.class)) {
            SCMSourceDescriptor descriptor;
            if (!(d instanceof SCMSourceDescriptor) || !(descriptor = (SCMSourceDescriptor)d).isApplicable(clazz) || onlyUserInstantiable && !descriptor.isUserInstantiable()) continue;
            result.add(descriptor);
        }
        return result;
    }
}

