/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.NoOpProjectObserver;

public abstract class SCMSourceObserver {
    @NonNull
    public abstract SCMSourceOwner getContext();

    @NonNull
    public abstract TaskListener getListener();

    @CheckForNull
    public Set<String> getIncludes() {
        return null;
    }

    @NonNull
    public abstract ProjectObserver observe(@NonNull String var1) throws IllegalArgumentException, IOException, InterruptedException;

    public abstract void addAttribute(@NonNull String var1, @Nullable Object var2) throws IllegalArgumentException, ClassCastException;

    public boolean isObserving() {
        return true;
    }

    @NonNull
    public static <O extends SCMSourceObserver> Filter<O> filter(O delegate, String ... projectNames) {
        return new Filter<O>(delegate, projectNames);
    }

    public static class Filter<O extends SCMSourceObserver>
    extends Wrapped<O> {
        private final Set<String> projectNames;
        private final Set<String> remaining;

        public Filter(O delegate, String ... projectNames) {
            super(delegate);
            this.projectNames = new HashSet<String>(Arrays.asList(projectNames));
            Set<String> includes = ((SCMSourceObserver)delegate).getIncludes();
            if (includes != null) {
                this.projectNames.retainAll(includes);
            }
            this.remaining = new HashSet<String>(this.projectNames);
        }

        @Override
        public Set<String> getIncludes() {
            return this.projectNames;
        }

        @Override
        @NonNull
        public ProjectObserver observe(@NonNull String projectName) throws IllegalArgumentException, IOException, InterruptedException {
            if (this.remaining.remove(projectName)) {
                return super.observe(projectName);
            }
            return NoOpProjectObserver.instance();
        }

        @Override
        public boolean isObserving() {
            return !this.remaining.isEmpty() && super.isObserving();
        }
    }

    public static abstract class Wrapped<O extends SCMSourceObserver>
    extends SCMSourceObserver {
        private final O delegate;

        protected Wrapped(O delegate) {
            this.delegate = delegate;
        }

        @Override
        @NonNull
        public SCMSourceOwner getContext() {
            return ((SCMSourceObserver)this.delegate).getContext();
        }

        @Override
        @NonNull
        public TaskListener getListener() {
            return ((SCMSourceObserver)this.delegate).getListener();
        }

        @Override
        @CheckForNull
        public Set<String> getIncludes() {
            return ((SCMSourceObserver)this.delegate).getIncludes();
        }

        @Override
        @NonNull
        public ProjectObserver observe(@NonNull String projectName) throws IllegalArgumentException, IOException, InterruptedException {
            return ((SCMSourceObserver)this.delegate).observe(projectName);
        }

        @Override
        public void addAttribute(@NonNull String key, @Nullable Object value) throws IllegalArgumentException, ClassCastException {
            ((SCMSourceObserver)this.delegate).addAttribute(key, value);
        }

        @Override
        public boolean isObserving() {
            return ((SCMSourceObserver)this.delegate).isObserving();
        }
    }

    public static abstract class ProjectObserver {
        public abstract void addSource(@NonNull SCMSource var1);

        public abstract void addAttribute(@NonNull String var1, @Nullable Object var2) throws IllegalArgumentException, ClassCastException;

        public abstract void complete() throws IllegalStateException, IOException, InterruptedException;
    }
}

