/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class SCMHeadMigration<S extends SCMSource, H extends SCMHead, R extends SCMRevision>
implements ExtensionPoint {
    private final Class<S> sourceClass;
    private final Class<H> headClass;
    private final Class<R> revisionClass;

    protected SCMHeadMigration(Class<S> sourceClass, Class<H> headClass, Class<R> revisionClass) {
        this.sourceClass = sourceClass;
        this.headClass = headClass;
        this.revisionClass = revisionClass;
    }

    public final Class<S> getSCMSourceClass() {
        return this.sourceClass;
    }

    public final Class<H> getSCMHeadClass() {
        return this.headClass;
    }

    public final Class<R> getSCMRevisionClass() {
        return this.revisionClass;
    }

    @CheckForNull
    public abstract SCMHead migrate(@NonNull S var1, @NonNull H var2);

    @CheckForNull
    public SCMRevision migrate(@NonNull S source, @NonNull R revision) {
        return null;
    }

    @NonNull
    public static SCMHead readResolveSCMHead(@NonNull SCMSource source, @NonNull SCMHead head) {
        for (SCMHeadMigration m : ExtensionList.lookup(SCMHeadMigration.class)) {
            SCMHead migrated;
            if (m.sourceClass != ((Object)((Object)source)).getClass() || m.headClass != head.getClass() || (migrated = m.migrate((S)((Object)source), (H)head)) == null) continue;
            return migrated;
        }
        return head;
    }

    @CheckForNull
    public static SCMRevision readResolveSCMRevision(@NonNull SCMSource source, @CheckForNull SCMRevision revision) {
        if (revision == null) {
            return null;
        }
        SCMHead head = revision.getHead();
        for (SCMHeadMigration m : ExtensionList.lookup(SCMHeadMigration.class)) {
            SCMRevision migrated;
            if (m.sourceClass != ((Object)((Object)source)).getClass() || m.headClass != head.getClass() || m.revisionClass != revision.getClass() || (migrated = m.migrate((S)((Object)source), (R)revision)) == null) continue;
            return migrated;
        }
        return revision;
    }
}

