/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import java.util.Random;
import java.util.concurrent.TimeUnit;

public abstract class MockLatency {
    private static final MockLatency NONE = new MockLatency(){

        @Override
        public void apply() throws InterruptedException {
        }
    };
    private static final MockLatency YIELD = new MockLatency(){

        @Override
        public void apply() throws InterruptedException {
            Thread.yield();
        }
    };

    public abstract void apply() throws InterruptedException;

    public static MockLatency fixed(final long time, final TimeUnit units) {
        return new MockLatency(){

            @Override
            public void apply() throws InterruptedException {
                units.sleep(time);
            }
        };
    }

    public static MockLatency fixedForOtherThreads(final long time, final TimeUnit units) {
        final Thread safe = Thread.currentThread();
        return new MockLatency(){

            @Override
            public void apply() throws InterruptedException {
                if (Thread.currentThread() != safe) {
                    units.sleep(time);
                }
            }
        };
    }

    public static MockLatency average(final long time, final TimeUnit units) {
        return new MockLatency(){
            final Random entropy = new Random();

            @Override
            public void apply() throws InterruptedException {
                long ms = units.toMillis(time);
                ms = Math.min(ms * 3L, Math.max((long)((double)ms + (double)ms * this.entropy.nextGaussian()), 1L));
                Thread.sleep(ms);
            }
        };
    }

    public static MockLatency yield() {
        return YIELD;
    }

    public static MockLatency none() {
        return NONE;
    }
}

