/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.impl.mock.MockChangeRequestFlags;
import jenkins.scm.impl.mock.MockFailure;
import jenkins.scm.impl.mock.MockLatency;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMNavigator;
import jenkins.scm.impl.mock.MockSCMNavigatorSaveListener;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.mock.MockSCMSourceSaveListener;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class MockSCMController
implements Closeable {
    private static Map<String, MockSCMController> instances = new WeakHashMap<String, MockSCMController>();
    private final String id;
    private Map<String, Repository> repositories = new TreeMap<String, Repository>();
    private List<MockFailure> faults = new ArrayList<MockFailure>();
    private List<MockSCMNavigatorSaveListener> navigatorSaveListeners = new ArrayList<MockSCMNavigatorSaveListener>();
    private List<MockSCMSourceSaveListener> sourceSaveListeners = new ArrayList<MockSCMSourceSaveListener>();
    @NonNull
    private MockLatency latency = MockLatency.none();
    private String displayName;
    private String description;
    private String url;
    private String repoIconClassName;
    private String orgIconClassName;

    private MockSCMController() {
        this(UUID.randomUUID().toString());
    }

    public MockSCMController(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MockSCMController create() {
        MockSCMController c = new MockSCMController();
        Map<String, MockSCMController> map = instances;
        synchronized (map) {
            instances.put(c.id, c);
        }
        return c;
    }

    public MockSCMController withLatency(@NonNull MockLatency latency) {
        this.latency = latency;
        return this;
    }

    public MockSCMController withSaveListener(MockSCMNavigatorSaveListener listener) {
        this.navigatorSaveListeners.add(listener);
        return this;
    }

    public MockSCMController withSaveListener(MockSCMSourceSaveListener listener) {
        this.sourceSaveListeners.add(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MockSCMController recreate(String id) {
        MockSCMController c = new MockSCMController(id);
        Map<String, MockSCMController> map = instances;
        synchronized (map) {
            if (instances.containsKey(id)) {
                return instances.get(id);
            }
            instances.put(id, c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MockSCMController> all() {
        Map<String, MockSCMController> map = instances;
        synchronized (map) {
            return new ArrayList<MockSCMController>(instances.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MockSCMController lookup(String id) {
        Map<String, MockSCMController> map = instances;
        synchronized (map) {
            return instances.get(id);
        }
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, MockSCMController> map = instances;
        synchronized (map) {
            instances.remove(this.id);
        }
        this.repositories.clear();
    }

    public String getRepoIconClassName() {
        return this.repoIconClassName;
    }

    public void setRepoIconClassName(String repoIconClassName) {
        this.repoIconClassName = repoIconClassName;
    }

    public String getOrgIconClassName() {
        return this.orgIconClassName;
    }

    public void setOrgIconClassName(String orgIconClassName) {
        this.orgIconClassName = orgIconClassName;
    }

    public String getDescription() throws IOException {
        return this.description;
    }

    public void setDescription(String description) throws IOException {
        this.description = description;
    }

    public String getDisplayName() throws IOException {
        return this.displayName;
    }

    public void setDisplayName(String displayName) throws IOException {
        this.displayName = displayName;
    }

    public String getUrl() throws IOException {
        return this.url;
    }

    public void setUrl(String url) throws IOException {
        this.url = url;
    }

    public synchronized void addFault(MockFailure fault) {
        this.faults.add(fault);
    }

    public synchronized void clearFaults() {
        this.faults.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLatency() throws InterruptedException {
        MockLatency latency;
        MockSCMController mockSCMController = this;
        synchronized (mockSCMController) {
            latency = this.latency;
        }
        latency.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFaults(@CheckForNull String repository, @CheckForNull String branch, @CheckForNull String revision, boolean actions) throws IOException, InterruptedException {
        ArrayList<MockFailure> faults;
        MockSCMController mockSCMController = this;
        synchronized (mockSCMController) {
            faults = new ArrayList<MockFailure>(this.faults);
        }
        for (MockFailure fault : faults) {
            fault.check(repository, branch, revision, actions);
        }
    }

    public synchronized void createRepository(String name, MockRepositoryFlags ... flags) throws IOException {
        this.repositories.put(name, new Repository(flags));
        this.createBranch(name, "master");
    }

    public synchronized void deleteRepository(String name) throws IOException {
        this.repositories.remove(name);
    }

    public synchronized List<String> listRepositories() throws IOException {
        return new ArrayList<String>(this.repositories.keySet());
    }

    public String getDescription(String repository) throws IOException {
        return this.resolve((String)repository).description;
    }

    public Set<MockRepositoryFlags> getFlags(String repository) throws IOException {
        return Collections.unmodifiableSet(this.resolve((String)repository).flags);
    }

    public void setDescription(String repository, String description) throws IOException {
        this.resolve((String)repository).description = description;
    }

    public String getDisplayName(String repository) throws IOException {
        return this.resolve((String)repository).displayName;
    }

    public void setDisplayName(String repository, String displayName) throws IOException {
        this.resolve((String)repository).displayName = displayName;
    }

    public String getUrl(String repository) throws IOException {
        return this.resolve((String)repository).url;
    }

    public void setUrl(String repository, String url) throws IOException {
        this.resolve((String)repository).url = url;
    }

    public synchronized void createBranch(String repository, String branch) throws IOException {
        State state = new State();
        Repository repo = this.resolve(repository);
        repo.revisions.put(state.getHash(), state);
        repo.heads.put(branch, state.getHash());
    }

    public synchronized void cloneBranch(String repository, String srcBranch, String dstBranch) throws IOException {
        Repository repo = this.resolve(repository);
        repo.heads.put(dstBranch, repo.heads.get(srcBranch));
    }

    public synchronized void deleteBranch(String repository, String branch) throws IOException {
        this.resolve((String)repository).heads.remove(branch);
    }

    public synchronized void setPrimaryBranch(String repository, @CheckForNull String branch) throws IOException {
        Repository repo = this.resolve(repository);
        repo.primaryBranch = branch;
    }

    public synchronized boolean isPrimaryBranch(String repository, @CheckForNull String branch) throws IOException {
        Repository repo = this.resolve(repository);
        return StringUtils.equals((String)repo.primaryBranch, (String)branch);
    }

    @CheckForNull
    public synchronized String getPrimaryBranch(String repository) throws IOException {
        Repository repo = this.resolve(repository);
        return repo.primaryBranch;
    }

    public synchronized long createTag(String repository, String branch, String tag) throws IOException {
        Repository repo = this.resolve(repository);
        long timestamp = System.currentTimeMillis();
        repo.tags.put(tag, this.resolve(repository, branch).getHash());
        repo.tagDates.put(tag, timestamp);
        return timestamp;
    }

    public synchronized void createTag(String repository, String branch, String tag, long when) throws IOException {
        Repository repo = this.resolve(repository);
        repo.tags.put(tag, this.resolve(repository, branch).getHash());
        repo.tagDates.put(tag, when);
    }

    public synchronized void deleteTag(String repository, String tag) throws IOException {
        this.resolve((String)repository).tags.remove(tag);
        this.resolve((String)repository).tagDates.remove(tag);
    }

    public synchronized Integer openChangeRequest(String repository, String branch, MockChangeRequestFlags ... flags) throws IOException {
        Repository repo = this.resolve(repository);
        String hash = this.resolve(repository, branch).getHash();
        Integer crNum = ++repo.lastChangeRequest;
        repo.changes.put(crNum, hash);
        repo.changeBaselines.put(crNum, branch);
        EnumSet<MockChangeRequestFlags> flagsSet = EnumSet.noneOf(MockChangeRequestFlags.class);
        for (MockChangeRequestFlags flag : flags) {
            if (!flag.isApplicable(repo.flags)) continue;
            flagsSet.add(flag);
        }
        repo.changeFlags.put(crNum, flagsSet);
        return crNum;
    }

    public synchronized void closeChangeRequest(String repository, Integer crNum) throws IOException {
        Repository r = this.resolve(repository);
        r.changes.remove(crNum);
        r.changeBaselines.remove(crNum);
        r.changeFlags.remove(crNum);
    }

    public synchronized String getTarget(String repository, Integer crNum) throws IOException {
        return this.resolve((String)repository).changeBaselines.get(crNum);
    }

    public synchronized Set<MockChangeRequestFlags> getFlags(String repository, Integer crNum) throws IOException {
        return Collections.unmodifiableSet(this.resolve((String)repository).changeFlags.get(crNum));
    }

    public synchronized List<String> listBranches(String repository) throws IOException {
        return new ArrayList<String>(this.resolve((String)repository).heads.keySet());
    }

    public synchronized List<String> listTags(String repository) throws IOException {
        return new ArrayList<String>(this.resolve((String)repository).tags.keySet());
    }

    public synchronized List<Integer> listChangeRequests(String repository) throws IOException {
        return new ArrayList<Integer>(this.resolve((String)repository).changes.keySet());
    }

    public synchronized String getRevision(String repository, String branch) throws IOException {
        return this.resolve(repository, branch).getHash();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addFile(String repository, String branchOrCR, String message, String path, byte[] content) throws IOException {
        Integer crNum;
        String branchName;
        Repository repo = this.resolve(repository);
        String hash = repo.heads.get(branchOrCR);
        if (hash == null) {
            branchName = null;
            Matcher m = Pattern.compile("change-request/(\\d+)").matcher(branchOrCR);
            if (!m.matches()) throw new IOException("Unknown branch: " + branchOrCR + " in repository " + repository);
            crNum = Integer.valueOf(m.group(1));
            hash = repo.changes.get(crNum);
            if (hash == null) {
                throw new IOException("Unknown change request: " + crNum + " in repository " + repository);
            }
        } else {
            branchName = branchOrCR;
            crNum = null;
        }
        State base = repo.revisions.get(hash);
        State state = new State(base, message, Collections.singletonMap(path, content), Collections.emptySet());
        repo.revisions.put(state.getHash(), state);
        if (branchName != null) {
            repo.heads.put(branchName, state.getHash());
        }
        if (crNum == null) return;
        repo.changes.put(crNum, state.getHash());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void rmFile(String repository, String branchOrCR, String message, String path) throws IOException {
        Integer crNum;
        String branchName;
        Repository repo = this.resolve(repository);
        String hash = repo.heads.get(branchOrCR);
        if (hash == null) {
            branchName = null;
            Matcher m = Pattern.compile("change-request/(\\d+)").matcher(branchOrCR);
            if (!m.matches()) throw new IOException("Unknown branch: " + branchOrCR + " in repository " + repository);
            crNum = Integer.valueOf(m.group(1));
            hash = repo.changes.get(crNum);
            if (hash == null) {
                throw new IOException("Unknown change request: " + crNum + " in repository " + repository);
            }
        } else {
            branchName = branchOrCR;
            crNum = null;
        }
        State base = repo.revisions.get(hash);
        State state = new State(base, message, Collections.emptyMap(), Collections.singleton(path));
        repo.revisions.put(state.getHash(), state);
        if (branchName != null) {
            repo.heads.put(branchName, state.getHash());
        }
        if (crNum == null) return;
        repo.changes.put(crNum, state.getHash());
    }

    public synchronized String checkout(File workspace, String repository, String identifier) throws IOException {
        State state = this.resolve(repository, identifier);
        for (Map.Entry<String, byte[]> entry : state.files.entrySet()) {
            FileUtils.writeByteArrayToFile((File)new File(workspace, entry.getKey()), (byte[])entry.getValue());
        }
        return state.getHash();
    }

    public synchronized String checkout(FilePath workspace, String repository, String identifier) throws IOException, InterruptedException {
        State state = this.resolve(repository, identifier);
        for (Map.Entry<String, byte[]> entry : state.files.entrySet()) {
            workspace.child(entry.getKey()).copyFrom((InputStream)new ByteArrayInputStream(entry.getValue()));
        }
        return state.getHash();
    }

    private synchronized State resolve(String repository, String identifier) throws IOException {
        String hash;
        Repository repo = this.resolve(repository);
        String string = hash = repo.revisions.containsKey(identifier) ? identifier : null;
        if (hash != null) {
            return repo.revisions.get(hash);
        }
        hash = repo.heads.get(identifier);
        if (hash != null) {
            return repo.revisions.get(hash);
        }
        hash = repo.tags.get(identifier);
        if (hash != null) {
            return repo.revisions.get(hash);
        }
        Matcher m = Pattern.compile("change-request/(\\d+)").matcher(identifier);
        if (m.matches()) {
            Integer crNum = Integer.valueOf(m.group(1));
            hash = repo.changes.get(crNum);
            if (hash != null) {
                return repo.revisions.get(hash);
            }
            throw new IOException("Unknown change request: " + crNum + " in repository " + repository);
        }
        throw new IOException("Unknown branch/tag/revision: " + identifier + " in repository " + repository);
    }

    private Repository resolve(String repository) throws IOException {
        Repository repo = this.repositories.get(repository);
        if (repo == null) {
            throw new IOException("Unknown repository: " + repository);
        }
        return repo;
    }

    public synchronized List<LogEntry> log(String repository, String identifier) throws IOException {
        State state = this.resolve(repository, identifier);
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        while (state != null) {
            result.add(new LogEntry(state.getHash(), state.timestamp, state.message, state.files.keySet()));
            state = state.parent;
        }
        return result;
    }

    public synchronized SCMFile.Type stat(String repository, String identifier, String path) throws IOException {
        State state = this.resolve(repository, identifier);
        if (state == null) {
            return SCMFile.Type.NONEXISTENT;
        }
        if (state.files.containsKey(path)) {
            return SCMFile.Type.REGULAR_FILE;
        }
        for (String p : state.files.keySet()) {
            if (!p.startsWith(path + "/")) continue;
            return SCMFile.Type.DIRECTORY;
        }
        return SCMFile.Type.NONEXISTENT;
    }

    public synchronized long lastModified(String repository, String identifier) {
        try {
            State state = this.resolve(repository, identifier);
            if (state == null) {
                return 0L;
            }
            return state.timestamp;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public synchronized long getTagTimestamp(String repository, String tag) throws IOException {
        Repository repo = this.repositories.get(repository);
        if (repo == null) {
            throw new IOException("Unknown repository: " + repository);
        }
        Long date = repo.tagDates.get(tag);
        if (tag == null) {
            throw new IOException("Unknown tag: null in repository " + repository);
        }
        return date;
    }

    public void afterSave(MockSCMSource source) {
        for (MockSCMSourceSaveListener listener : this.sourceSaveListeners) {
            listener.afterSave(source);
        }
    }

    public void afterSave(MockSCMNavigator navigator, SCMNavigatorOwner owner) {
        for (MockSCMNavigatorSaveListener listener : this.navigatorSaveListeners) {
            listener.afterSave(navigator, owner);
        }
    }

    static String toHexBinary(byte[] bytes) {
        return new String(Hex.encodeHex((byte[])bytes));
    }

    private static class Repository {
        private Map<String, State> revisions = new TreeMap<String, State>();
        private Map<String, String> heads = new TreeMap<String, String>();
        private Map<String, String> tags = new TreeMap<String, String>();
        private Map<String, Long> tagDates = new TreeMap<String, Long>();
        private Map<Integer, String> changes = new TreeMap<Integer, String>();
        private Map<Integer, Set<MockChangeRequestFlags>> changeFlags = new TreeMap<Integer, Set<MockChangeRequestFlags>>();
        private Map<Integer, String> changeBaselines = new TreeMap<Integer, String>();
        private int lastChangeRequest;
        private String description;
        private String displayName;
        private String url;
        private String primaryBranch;
        private Set<MockRepositoryFlags> flags;

        private Repository(MockRepositoryFlags ... flags) {
            this.flags = flags.length == 0 ? Collections.emptySet() : EnumSet.copyOf(Arrays.asList(flags));
        }
    }

    private static class State {
        private final State parent;
        private final String message;
        private final long timestamp;
        private final Map<String, byte[]> files;
        private transient String hash;

        public State() {
            this.parent = null;
            this.message = null;
            this.timestamp = System.currentTimeMillis();
            this.files = new TreeMap<String, byte[]>();
        }

        public State(State parent, String message, Map<String, byte[]> added, Set<String> removed) {
            this.parent = parent;
            this.message = message;
            this.timestamp = System.currentTimeMillis();
            TreeMap<String, byte[]> files = parent != null ? new TreeMap<String, byte[]>(parent.files) : new TreeMap();
            files.keySet().removeAll(removed);
            files.putAll(added);
            this.files = files;
        }

        public String getHash() {
            if (this.hash == null) {
                try {
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    if (this.parent != null) {
                        sha.update(new BigInteger(this.parent.getHash(), 16).toByteArray());
                    }
                    sha.update(StringUtils.defaultString((String)this.message).getBytes(StandardCharsets.UTF_8));
                    sha.update((byte)(this.timestamp & 0xFFL));
                    sha.update((byte)(this.timestamp >> 8 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 16 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 24 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 32 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 40 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 48 & 0xFFL));
                    sha.update((byte)(this.timestamp >> 56 & 0xFFL));
                    for (Map.Entry<String, byte[]> e : this.files.entrySet()) {
                        sha.update(e.getKey().getBytes(StandardCharsets.UTF_8));
                        sha.update(e.getValue());
                    }
                    this.hash = MockSCMController.toHexBinary(sha.digest());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("SHA-1 message digest mandated by JLS");
                }
            }
            return this.hash;
        }
    }

    public static final class LogEntry {
        private final String hash;
        private final long timestamp;
        private final String message;
        private final Set<String> files;

        private LogEntry(String hash, long timestamp, String message, Set<String> files) {
            this.hash = hash;
            this.timestamp = timestamp;
            this.message = message;
            this.files = Collections.unmodifiableSet(files);
        }

        public String getHash() {
            return this.hash;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        public Set<String> getFiles() {
            return this.files;
        }

        public String toString() {
            return String.format("Commit %s%nDate: %tc%n%s%n", this.hash, this.timestamp, this.message);
        }
    }
}

