/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.SCMHeadMixin;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.ClassUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class SCMHeadMixinEqualityGenerator
extends ClassLoader {
    private static final boolean forceReflection = Boolean.getBoolean(SCMHeadMixinEqualityGenerator.class.getName() + ".forceReflection");
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private static final Map<ClassLoader, SCMHeadMixinEqualityGenerator> generators = new WeakHashMap<ClassLoader, SCMHeadMixinEqualityGenerator>();
    @GuardedBy(value="lock")
    private static final WeakHashMap<Class<? extends SCMHead>, SCMHeadMixin.Equality> mixinEqualities = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static SCMHeadMixin.Equality getOrCreate(@NonNull Class<? extends SCMHead> type) {
        SCMHeadMixin.Equality result;
        lock.readLock().lock();
        try {
            result = mixinEqualities.get(type);
            if (result != null) {
                SCMHeadMixin.Equality equality = result;
                return equality;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            result = mixinEqualities.get(type);
            if (result != null) {
                SCMHeadMixin.Equality equality = result;
                return equality;
            }
            final ClassLoader loader = type.getClassLoader();
            SCMHeadMixinEqualityGenerator generator = generators.get(loader);
            if (generator == null) {
                generator = AccessController.doPrivileged(new PrivilegedAction<SCMHeadMixinEqualityGenerator>(){

                    @Override
                    public SCMHeadMixinEqualityGenerator run() {
                        return new SCMHeadMixinEqualityGenerator(loader);
                    }
                });
                generators.put(loader, generator);
            }
            result = generator.create(type);
            mixinEqualities.put(type, result);
            SCMHeadMixin.Equality equality = result;
            return equality;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private SCMHeadMixinEqualityGenerator(ClassLoader parent) {
        super(parent);
    }

    @NonNull
    private SCMHeadMixin.Equality create(@NonNull Class<? extends SCMHead> type) {
        TreeMap<Object, Method> properties = new TreeMap<Object, Method>();
        for (Class clazz : ClassUtils.getAllInterfaces(type)) {
            if (!SCMHeadMixin.class.isAssignableFrom(clazz) || SCMHeadMixin.class == clazz || !Modifier.isPublic(clazz.getModifiers())) continue;
            for (Method method : clazz.getDeclaredMethods()) {
                Object name;
                if (method.getReturnType() == Void.class || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || !((String)(name = method.getName())).matches("^((is[A-Z0-9_].*)|(get[A-Z0-9_].*))$") || properties.containsKey(name = ((String)name).startsWith("is") ? Character.toLowerCase(((String)name).charAt(2)) + (((String)name).length() > 3 ? ((String)name).substring(3) : "") : Character.toLowerCase(((String)name).charAt(3)) + (((String)name).length() > 4 ? ((String)name).substring(4) : ""))) continue;
                properties.put(name, method);
            }
        }
        if (properties.isEmpty()) {
            return new ConstantEquality();
        }
        if (forceReflection) {
            return new ReflectiveEquality(properties.values().toArray(new Method[0]));
        }
        ClassWriter cw = new ClassWriter(2);
        String name = SCMHeadMixin.class.getPackage().getName() + ".internal." + type.getName();
        cw.visit(51, 1, name.replace('.', '/'), null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(SCMHeadMixin.Equality.class)});
        this.generateDefaultConstructor(cw);
        this.generateEquals(cw, properties.values());
        byte[] image = cw.toByteArray();
        Class<SCMHeadMixin.Equality> c = this.defineClass(name, image, 0, image.length).asSubclass(SCMHeadMixin.Equality.class);
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return new ReflectiveEquality(properties.values().toArray(new Method[0]));
        }
    }

    private void generateEquals(@NonNull ClassWriter cw, @NonNull Collection<Method> methods) {
        String scmHeadMixinDescriptor = Type.getDescriptor(SCMHeadMixin.class);
        MethodVisitor mv = cw.visitMethod(1, "equals", "(" + scmHeadMixinDescriptor + scmHeadMixinDescriptor + ")Z", null, null);
        mv.visitCode();
        boolean bigStack = false;
        for (Method m : methods) {
            Label l1;
            String declClass = Type.getInternalName(m.getDeclaringClass());
            Class<?> returnType = m.getReturnType();
            String methodDesc = "()" + Type.getDescriptor(returnType);
            if (Boolean.TYPE.equals(returnType) || Byte.TYPE.equals(returnType) || Character.TYPE.equals(returnType) || Integer.TYPE.equals(returnType) || Short.TYPE.equals(returnType)) {
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(54, 3);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(21, 3);
                l1 = new Label();
                mv.visitJumpInsn(159, l1);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            if (Long.TYPE.equals(returnType)) {
                bigStack = true;
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(55, 3);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(55, 5);
                mv.visitVarInsn(22, 3);
                mv.visitVarInsn(22, 5);
                mv.visitInsn(148);
                l1 = new Label();
                mv.visitJumpInsn(153, l1);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            if (Double.TYPE.equals(returnType)) {
                bigStack = true;
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(57, 3);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(57, 5);
                mv.visitVarInsn(24, 3);
                mv.visitVarInsn(24, 5);
                mv.visitInsn(151);
                l1 = new Label();
                mv.visitJumpInsn(153, l1);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            if (Float.TYPE.equals(returnType)) {
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(56, 3);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, declClass);
                mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
                mv.visitVarInsn(56, 5);
                mv.visitVarInsn(23, 3);
                mv.visitVarInsn(23, 5);
                mv.visitInsn(149);
                l1 = new Label();
                mv.visitJumpInsn(153, l1);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, declClass);
            mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
            mv.visitVarInsn(58, 3);
            mv.visitVarInsn(25, 2);
            mv.visitTypeInsn(192, declClass);
            mv.visitMethodInsn(185, declClass, m.getName(), methodDesc, true);
            mv.visitVarInsn(58, 4);
            mv.visitVarInsn(25, 3);
            l1 = new Label();
            Label l2 = new Label();
            Label l3 = new Label();
            mv.visitJumpInsn(199, l1);
            mv.visitVarInsn(25, 4);
            mv.visitJumpInsn(198, l3);
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 4);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, Type.getInternalName(Object.class), "equals", "(Ljava/lang/Object;)Z", false);
            mv.visitJumpInsn(154, l3);
            mv.visitLabel(l2);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l3);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(bigStack ? 4 : 2, bigStack ? 7 : 5);
        mv.visitEnd();
    }

    private void generateDefaultConstructor(@NonNull ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static class ConstantEquality
    implements SCMHeadMixin.Equality {
        private ConstantEquality() {
        }

        @Override
        public boolean equals(@NonNull SCMHeadMixin o1, @NonNull SCMHeadMixin o2) {
            return true;
        }
    }

    private static class ReflectiveEquality
    implements SCMHeadMixin.Equality {
        private final Method[] props;

        private ReflectiveEquality(Method[] props) {
            this.props = props;
        }

        @Override
        public boolean equals(@NonNull SCMHeadMixin o1, @NonNull SCMHeadMixin o2) {
            for (Method p : this.props) {
                Object p2;
                Object p1;
                try {
                    p1 = p.invoke((Object)o1, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    try {
                        p.invoke((Object)o2, new Object[0]);
                        return false;
                    }
                    catch (IllegalAccessException e1) {
                        continue;
                    }
                    catch (InvocationTargetException e1) {
                        return false;
                    }
                }
                catch (InvocationTargetException e) {
                    try {
                        p.invoke((Object)o2, new Object[0]);
                        return false;
                    }
                    catch (IllegalAccessException e1) {
                        return false;
                    }
                    catch (InvocationTargetException e1) {
                        continue;
                    }
                }
                try {
                    p2 = p.invoke((Object)o2, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return false;
                }
                if (Objects.equals(p1, p2)) continue;
                return false;
            }
            return true;
        }
    }
}

