/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecureGroovyScript
extends AbstractDescribableImpl<SecureGroovyScript> {
    private final String script;
    private final boolean sandbox;
    @CheckForNull
    private final List<ClasspathEntry> classpath;
    private transient boolean calledConfiguring;

    @DataBoundConstructor
    public SecureGroovyScript(String script, boolean sandbox, @CheckForNull List<ClasspathEntry> classpath) {
        this.script = script;
        this.sandbox = sandbox;
        this.classpath = classpath;
    }

    @Deprecated
    public SecureGroovyScript(String script, boolean sandbox) {
        this(script, sandbox, null);
    }

    private Object readResolve() {
        this.configuring(ApprovalContext.create());
        return this;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    @Nonnull
    public List<ClasspathEntry> getClasspath() {
        return this.classpath != null ? this.classpath : Collections.emptyList();
    }

    public SecureGroovyScript configuring(ApprovalContext context) {
        this.calledConfiguring = true;
        if (!this.sandbox) {
            ScriptApproval.get().configuring(this.script, GroovyLanguage.get(), context);
        }
        for (ClasspathEntry entry : this.getClasspath()) {
            ScriptApproval.get().configuring(entry, context);
        }
        return this;
    }

    @CheckForNull
    private static Item currentItem() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return req != null ? (Item)req.findAncestorObject(Item.class) : null;
    }

    public SecureGroovyScript configuringWithKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItemAsKey(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    public SecureGroovyScript configuringWithNonKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItem(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    public Object evaluate(ClassLoader loader, Binding binding) throws Exception {
        if (!this.calledConfiguring) {
            throw new IllegalStateException("you need to call configuring or a related method before using GroovyScript");
        }
        List<ClasspathEntry> cp = this.getClasspath();
        if (!cp.isEmpty()) {
            ArrayList<URL> urlList = new ArrayList<URL>(cp.size());
            for (ClasspathEntry entry : cp) {
                ScriptApproval.get().using(entry);
                urlList.add(entry.getURL());
            }
            loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), loader);
        }
        loader = GroovySandbox.createSecureClassLoader(loader);
        if (this.sandbox) {
            GroovyShell shell = new GroovyShell(loader, binding, GroovySandbox.createSecureCompilerConfiguration());
            try {
                return GroovySandbox.run(shell.parse(this.script), Whitelist.all());
            }
            catch (RejectedAccessException x) {
                throw ScriptApproval.get().accessRejected(x, ApprovalContext.create());
            }
        }
        return new GroovyShell(loader, binding).evaluate(ScriptApproval.get().using(this.script, GroovyLanguage.get()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecureGroovyScript> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckScript(@QueryParameter String value, @QueryParameter boolean sandbox) {
            try {
                new GroovyShell(Jenkins.getInstance().getPluginManager().uberClassLoader).parse(value);
            }
            catch (CompilationFailedException x) {
                return FormValidation.error((String)x.getLocalizedMessage());
            }
            return sandbox ? FormValidation.ok() : ScriptApproval.get().checking(value, GroovyLanguage.get());
        }
    }
}

