/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumeratingWhitelist
extends Whitelist {
    protected abstract List<MethodSignature> methodSignatures();

    protected abstract List<NewSignature> newSignatures();

    protected abstract List<MethodSignature> staticMethodSignatures();

    protected abstract List<FieldSignature> fieldSignatures();

    protected abstract List<FieldSignature> staticFieldSignatures();

    @Override
    public final boolean permitsMethod(Method method, Object receiver, Object[] args) {
        for (MethodSignature s : this.methodSignatures()) {
            if (!s.matches(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        for (NewSignature s : this.newSignatures()) {
            if (!s.matches(constructor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticMethod(Method method, Object[] args) {
        for (MethodSignature s : this.staticMethodSignatures()) {
            if (!s.matches(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldGet(Field field, Object receiver) {
        for (FieldSignature s : this.fieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldSet(Field field, Object receiver, Object value) {
        for (FieldSignature s : this.fieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldGet(Field field) {
        for (FieldSignature s : this.staticFieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldSet(Field field, Object value) {
        for (FieldSignature s : this.staticFieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    public static String getName(Class<?> c) {
        Class<?> e = c.getComponentType();
        if (e == null) {
            return c.getName();
        }
        return EnumeratingWhitelist.getName(e) + "[]";
    }

    private static String[] argumentTypes(Class<?>[] argumentTypes) {
        String[] s = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            s[i] = EnumeratingWhitelist.getName(argumentTypes[i]);
        }
        return s;
    }

    private static boolean is(String thisIdentifier, String identifier) {
        return thisIdentifier.equals("*") || identifier.equals(thisIdentifier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FieldSignature {
        private final String type;
        private final String field;

        public FieldSignature(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public FieldSignature(Class<?> type, String field) {
            this(EnumeratingWhitelist.getName(type), field);
        }

        boolean matches(Field f) {
            return EnumeratingWhitelist.is(this.field, f.getName()) && EnumeratingWhitelist.getName(f.getDeclaringClass()).equals(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NewSignature {
        private final String type;
        private final String[] argumentTypes;

        public NewSignature(String type, String[] argumentTypes) {
            this.type = type;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public NewSignature(Class<?> type, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(type), EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        boolean matches(Constructor c) {
            return EnumeratingWhitelist.getName(c.getDeclaringClass()).equals(this.type) && Arrays.equals(EnumeratingWhitelist.argumentTypes(c.getParameterTypes()), this.argumentTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MethodSignature {
        private final String receiverType;
        private final String method;
        private final String[] argumentTypes;

        public MethodSignature(String receiverType, String method, String[] argumentTypes) {
            this.receiverType = receiverType;
            this.method = method;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public MethodSignature(Class<?> receiverType, String method, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(receiverType), method, EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        public String toString() {
            return this.receiverType + "." + this.method + Arrays.toString(this.argumentTypes);
        }

        boolean matches(Method m) {
            return EnumeratingWhitelist.is(this.method, m.getName()) && EnumeratingWhitelist.getName(m.getDeclaringClass()).equals(this.receiverType) && Arrays.equals(EnumeratingWhitelist.argumentTypes(m.getParameterTypes()), this.argumentTypes);
        }
    }
}

