/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AclAwareWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public final class AnnotatedWhitelist
extends AclAwareWhitelist {
    public AnnotatedWhitelist() {
        super(new Impl(false), new Impl(true));
    }

    private static final class Impl
    extends Whitelist {
        private final boolean restricted;

        Impl(boolean restricted) {
            this.restricted = restricted;
        }

        private boolean allowed(@NonNull AccessibleObject o) {
            Whitelisted ann = o.getAnnotation(Whitelisted.class);
            if (ann == null) {
                return false;
            }
            return ann.restricted() == this.restricted;
        }

        @Override
        public boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
            return this.allowed(method);
        }

        @Override
        public boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
            return this.allowed(constructor);
        }

        @Override
        public boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
            return this.allowed(method);
        }

        @Override
        public boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsStaticFieldGet(@NonNull Field field) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
            return this.allowed(field);
        }
    }
}

