/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway;

import hudson.Functions;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public class Util {
    private static Boolean isTestEnv = null;

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJSONPayload(StaplerRequest2 request) throws IOException {
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding == null) {
            characterEncoding = "UTF-8";
        }
        InputStreamReader streamReader = new InputStreamReader((InputStream)request.getInputStream(), characterEncoding);
        try {
            String payloadAsString = IOUtils.toString((Reader)streamReader);
            JSONObject jSONObject = JSONObject.fromObject((Object)payloadAsString);
            return jSONObject;
        }
        finally {
            IOUtils.closeQuietly((Reader)streamReader);
        }
    }

    public static boolean isTestEnv() {
        if (isTestEnv != null) {
            return isTestEnv;
        }
        if (Functions.getIsUnitTest()) {
            isTestEnv = true;
        } else if (new File("./target/.jenkins_test").exists()) {
            isTestEnv = true;
        } else if (new File("./target/classes/" + Util.class.getName().replace(".", "/") + ".class").exists()) {
            isTestEnv = true;
        }
        if (isTestEnv == null) {
            isTestEnv = false;
        }
        return isTestEnv;
    }

    public static Map<String, String> getSessionInfo(HttpSession session) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionid", session.getId());
        info.put("cookieName", session.getServletContext().getSessionCookieConfig().getName());
        return info;
    }
}

