/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.ParameterType;
import org.jenkinsci.plugins.structs.describable.Setter;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.NoStaplerConstructorException;

public final class DescribableParameter {
    private final DescribableModel parent;
    private ParameterType type;
    private final String name;
    private final Type rawType;
    final Setter setter;
    private static final Logger LOGGER = Logger.getLogger(DescribableParameter.class.getName());

    DescribableParameter(DescribableModel parent, Type type, String name, Setter setter) {
        this.parent = parent;
        this.rawType = type;
        this.name = name;
        this.setter = setter;
    }

    public ParameterType getType() {
        if (this.type == null) {
            this.type = ParameterType.of(this.rawType);
        }
        return this.type;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public String getName() {
        return this.name;
    }

    public String getCapitalizedName() {
        return Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public boolean isRequired() {
        return this.setter == null;
    }

    @CheckForNull
    public String getHelp() throws IOException {
        return this.parent.getHelp("help-" + this.name + ".html");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.name);
        if (!this.isRequired()) {
            sb.append('?');
        }
        return sb.append(": ").append(this.getType()).toString();
    }

    Object inspect(Object o) {
        return this.uncoerce(this.getValue(o), this.rawType);
    }

    private Object getValue(Object o) {
        Class ownerClass = this.parent.getType();
        try {
            try {
                return ownerClass.getField(this.name).get(o);
            }
            catch (NoSuchFieldException x) {
                try {
                    return ownerClass.getMethod("get" + this.getCapitalizedName(), new Class[0]).invoke(o, new Object[0]);
                }
                catch (NoSuchMethodException x2) {
                    try {
                        return ownerClass.getMethod("is" + this.getCapitalizedName(), new Class[0]).invoke(o, new Object[0]);
                    }
                    catch (NoSuchMethodException x3) {
                        throw new UnsupportedOperationException("no public field \u2018" + this.name + "\u2019 (or getter method) found in " + ownerClass);
                    }
                }
            }
        }
        catch (UnsupportedOperationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new UnsupportedOperationException(x);
        }
    }

    private Object uncoerce(Object o, Type type) {
        block11: {
            if (type instanceof Class && ((Class)type).isEnum() && o instanceof Enum) {
                return ((Enum)o).name();
            }
            if (type == URL.class && o instanceof URL) {
                return o.toString();
            }
            if ((type == Character.class || type == Character.TYPE) && o instanceof Character) {
                return o.toString();
            }
            if (o instanceof Object[]) {
                Object[] array;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object elt : array = (Object[])o) {
                    list.add(this.uncoerce(elt, array.getClass().getComponentType()));
                }
                return list;
            }
            if (o instanceof Collection && Types.isSubClassOf((Type)type, Collection.class)) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object elt : (Collection)o) {
                    list.add(this.uncoerce(elt, Types.getTypeArgument((Type)Types.getBaseClass((Type)type, Collection.class), (int)0, Object.class)));
                }
                return list;
            }
            if (o != null && !o.getClass().getName().startsWith("java.")) {
                try {
                    Map<String, Object> nested = DescribableModel.uninstantiate_(o);
                    if (type != o.getClass()) {
                        nested.put("$class", o.getClass().getSimpleName());
                    }
                    return nested;
                }
                catch (UnsupportedOperationException x) {
                    if (x.getCause() instanceof NoStaplerConstructorException) break block11;
                    LOGGER.log(Level.WARNING, "failed to uncoerce " + o, x);
                }
            }
        }
        return o;
    }
}

