/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.timestamper.Timestamp;
import java.util.Collections;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;

final class PrecisionTimestampFormat
implements Function<Timestamp, String> {
    private final int precision;

    PrecisionTimestampFormat(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision is negative");
        }
        this.precision = precision;
    }

    @Override
    public String apply(@NonNull Timestamp timestamp) {
        long seconds = timestamp.elapsedMillis / 1000L;
        if (this.precision == 0) {
            return String.valueOf(seconds);
        }
        long millis = timestamp.elapsedMillis % 1000L;
        Object fractional = String.format("%03d", millis);
        fractional = this.precision <= 3 ? ((String)fractional).substring(0, this.precision) : (String)fractional + String.join((CharSequence)"", Collections.nCopies(this.precision - 3, "0"));
        return seconds + "." + (String)fractional;
    }

    public int hashCode() {
        return Integer.valueOf(this.precision).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrecisionTimestampFormat) {
            PrecisionTimestampFormat other = (PrecisionTimestampFormat)obj;
            return this.precision == other.precision;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("precision", this.precision).toString();
    }
}

