/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import java.util.regex.Pattern;

class FormatStringUtils {
    private static final Pattern START_TAG_PATTERN = Pattern.compile("\\<\\p{Alpha}+.*?\\>", 2);
    private static final Pattern END_TAG_PATTERN = Pattern.compile("\\</\\p{Alpha}+\\>", 2);
    private static final String QUOTED_WHITESPACE = "\\s*'\\s*'\\s*";

    FormatStringUtils() {
    }

    static String stripHtmlTags(String input) {
        input = START_TAG_PATTERN.matcher(input).replaceAll("");
        input = END_TAG_PATTERN.matcher(input).replaceAll("");
        return input;
    }

    static String trim(String input) {
        input = input.replaceFirst("^\\s*'\\s*'\\s*", "");
        input = input.replaceFirst("\\s*'\\s*'\\s*$", "");
        return input.trim();
    }
}

