/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import hudson.plugins.timestamper.io.Varint;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.input.CountingInputStream;

public final class DumpTimestamps {
    public static void main(String ... args) throws IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("no command-line arguments");
        }
        Path timestamperDir = Paths.get(args[0], new String[0]);
        DumpTimestamps.dump(timestamperDir, "timestamps", 1);
        System.out.println();
        DumpTimestamps.dump(timestamperDir, "timeshifts", 2);
    }

    private static void dump(Path parent, String filename, int columns) throws IOException {
        System.out.println(filename);
        Path file = parent.resolve(filename);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            System.out.println("(none)");
            return;
        }
        byte[] fileContents = Files.readAllBytes(file);
        CountingInputStream inputStream = new CountingInputStream((InputStream)new ByteArrayInputStream(fileContents));
        ArrayList<String> values = new ArrayList<String>();
        while (inputStream.getCount() < fileContents.length) {
            values.add(Long.toString(Varint.read((InputStream)inputStream)));
            if (values.size() != columns) continue;
            System.out.println(String.join((CharSequence)"\t", values));
            values.clear();
        }
        if (!values.isEmpty()) {
            System.out.println(String.join((CharSequence)"\t", values));
        }
    }

    private DumpTimestamps() {
    }
}

