/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.input.CountingInputStream;

class TimeShiftsReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File timeShiftsFile;
    @CheckForNull
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Map<Long, Long> timeShifts;

    TimeShiftsReader(Run<?, ?> build) {
        this.timeShiftsFile = TimestamperPaths.timeShiftsFile(build).toFile();
    }

    Optional<Long> getTime(long timestampEntry) throws IOException {
        if (this.timeShifts == null) {
            this.timeShifts = Collections.unmodifiableMap(this.readTimeShifts());
        }
        return Optional.ofNullable(this.timeShifts.get(timestampEntry));
    }

    private Map<Long, Long> readTimeShifts() throws IOException {
        if (!Files.isRegularFile(this.timeShiftsFile.toPath(), new LinkOption[0])) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> timeShifts = new HashMap<Long, Long>();
        try (CountingInputStream inputStream = new CountingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.timeShiftsFile.toPath(), new OpenOption[0])));){
            while ((long)inputStream.getCount() < Files.size(this.timeShiftsFile.toPath())) {
                long entry = Varint.read((InputStream)inputStream);
                long shift = Varint.read((InputStream)inputStream);
                timeShifts.put(entry, shift);
            }
        }
        return timeShifts;
    }
}

