/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public final class NodeStepTypePredicate
implements Predicate<FlowNode> {
    StepDescriptor stepDescriptor;

    public NodeStepTypePredicate(@NonNull StepDescriptor descriptorType) {
        this.stepDescriptor = descriptorType;
    }

    public NodeStepTypePredicate(@NonNull String functionName) {
        this.stepDescriptor = StepDescriptor.byFunctionName((String)functionName);
    }

    public StepDescriptor getStepDescriptor() {
        return this.stepDescriptor;
    }

    public boolean apply(@Nullable FlowNode input) {
        if (input instanceof StepNode) {
            return ((StepNode)((Object)input)).getDescriptor() == this.stepDescriptor;
        }
        if (input != null && !(input instanceof FlowStartNode) && !(input instanceof FlowEndNode)) {
            try {
                Method getDescriptorMethod = ((Object)((Object)input)).getClass().getMethod("getDescriptor", null);
                StepDescriptor sd = (StepDescriptor)getDescriptorMethod.invoke((Object)input, null);
                return sd == this.stepDescriptor;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

