/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import hudson.remoting.ProxyException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.NullOutputStream;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;

public class ErrorAction
implements PersistentAction {
    @Nonnull
    private final Throwable error;

    public ErrorAction(@Nonnull Throwable error) {
        if (this.isUnserializableException(error)) {
            error = new ProxyException(error);
        } else if (error != null) {
            try {
                Jenkins.XSTREAM2.toXMLUTF8((Object)error, (OutputStream)new NullOutputStream());
            }
            catch (Exception x) {
                error = new ProxyException(error);
            }
        }
        this.error = error;
    }

    private boolean isUnserializableException(@CheckForNull Throwable error) {
        if (error == null) {
            return false;
        }
        if (error.getClass().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MissingPropertyException && ((MissingPropertyException)error).getType().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MultipleCompilationErrorsException || error instanceof MissingMethodException) {
            return true;
        }
        if (this.isUnserializableException(error.getCause())) {
            return true;
        }
        for (Throwable t : error.getSuppressed()) {
            if (!this.isUnserializableException(t)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Throwable getError() {
        return this.error;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return this.error.getMessage();
    }

    public String getUrlName() {
        return null;
    }
}

