/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class FlowGraphWalker
implements Iterable<FlowNode> {
    Stack<FlowNode> q = new Stack();
    Set<FlowNode> visited = new HashSet<FlowNode>();

    public FlowGraphWalker(FlowExecution exec) {
        this.q.addAll(exec.getCurrentHeads());
    }

    public FlowGraphWalker() {
    }

    public void addHead(FlowNode head) {
        this.q.add(head);
    }

    public void addHeads(List<FlowNode> heads) {
        ListIterator<FlowNode> itr = heads.listIterator(heads.size());
        while (itr.hasPrevious()) {
            this.q.add(itr.previous());
        }
    }

    @Deprecated
    public FlowNode next() {
        while (!this.q.isEmpty()) {
            FlowNode n = this.q.pop();
            if (!this.visited.add(n)) continue;
            this.addHeads(n.getParents());
            return n;
        }
        return null;
    }

    @Override
    public Iterator<FlowNode> iterator() {
        return new FlowGraphWalkerIterator();
    }

    private class FlowGraphWalkerIterator
    implements Iterator<FlowNode> {
        private FlowNode next;
        private int expectedCount;

        public FlowGraphWalkerIterator() {
            this.expectedCount = FlowGraphWalker.this.q.size();
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FlowNode next() {
            FlowNode temp = this.next;
            this.next = this.getNext();
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private FlowNode getNext() {
            this.checkForComodification();
            while (!FlowGraphWalker.this.q.isEmpty()) {
                FlowNode n = FlowGraphWalker.this.q.pop();
                if (!FlowGraphWalker.this.visited.add(n)) continue;
                List<FlowNode> parents = n.getParents();
                FlowGraphWalker.this.addHeads(parents);
                this.expectedCount = FlowGraphWalker.this.q.size();
                return n;
            }
            return null;
        }

        private void checkForComodification() {
            if (FlowGraphWalker.this.q.size() != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

