// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.flow;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code FlowDurabilityHint.MAX_SURVIVABILITY.description}: {@code
     * Maximum durability but slowest (previously the only option)}.
     * 
     * @return
     *     {@code Maximum durability but slowest (previously the only option)}
     */
    public static String FlowDurabilityHint_MAX_SURVIVABILITY_description() {
        return holder.format("FlowDurabilityHint.MAX_SURVIVABILITY.description");
    }

    /**
     * Key {@code FlowDurabilityHint.MAX_SURVIVABILITY.description}: {@code
     * Maximum durability but slowest (previously the only option)}.
     * 
     * @return
     *     {@code Maximum durability but slowest (previously the only option)}
     */
    public static Localizable _FlowDurabilityHint_MAX_SURVIVABILITY_description() {
        return new Localizable(holder, "FlowDurabilityHint.MAX_SURVIVABILITY.description");
    }

    /**
     * Key {@code FlowDurabilityHint.PERFORMANCE_OPTIMIZED.description}:
     * {@code Performance-optimized: much faster (requires clean shutdown to
     * save running pipelines)}.
     * 
     * @return
     *     {@code Performance-optimized: much faster (requires clean shutdown to
     *     save running pipelines)}
     */
    public static String FlowDurabilityHint_PERFORMANCE_OPTIMIZED_description() {
        return holder.format("FlowDurabilityHint.PERFORMANCE_OPTIMIZED.description");
    }

    /**
     * Key {@code FlowDurabilityHint.PERFORMANCE_OPTIMIZED.description}:
     * {@code Performance-optimized: much faster (requires clean shutdown to
     * save running pipelines)}.
     * 
     * @return
     *     {@code Performance-optimized: much faster (requires clean shutdown to
     *     save running pipelines)}
     */
    public static Localizable _FlowDurabilityHint_PERFORMANCE_OPTIMIZED_description() {
        return new Localizable(holder, "FlowDurabilityHint.PERFORMANCE_OPTIMIZED.description");
    }

    /**
     * Key {@code FlowDurabilityHint.SURVIVABLE_NONATOMIC.description}:
     * {@code Less durability, a bit faster (specialty use only)}.
     * 
     * @return
     *     {@code Less durability, a bit faster (specialty use only)}
     */
    public static String FlowDurabilityHint_SURVIVABLE_NONATOMIC_description() {
        return holder.format("FlowDurabilityHint.SURVIVABLE_NONATOMIC.description");
    }

    /**
     * Key {@code FlowDurabilityHint.SURVIVABLE_NONATOMIC.description}:
     * {@code Less durability, a bit faster (specialty use only)}.
     * 
     * @return
     *     {@code Less durability, a bit faster (specialty use only)}
     */
    public static Localizable _FlowDurabilityHint_SURVIVABLE_NONATOMIC_description() {
        return new Localizable(holder, "FlowDurabilityHint.SURVIVABLE_NONATOMIC.description");
    }

    /**
     * Key {@code FlowDurabilityHint.MAX_SURVIVABILITY.tooltip}: {@code
     * Writes data with every step, using atomic writes for integrity. 
     * Provides maximum ability to retain running pipeline data and resume in
     * the event of a Jenkins failure.}.
     * 
     * @return
     *     {@code Writes data with every step, using atomic writes for integrity.
     *     Provides maximum ability to retain running pipeline data and resume in
     *     the event of a Jenkins failure.}
     */
    public static String FlowDurabilityHint_MAX_SURVIVABILITY_tooltip() {
        return holder.format("FlowDurabilityHint.MAX_SURVIVABILITY.tooltip");
    }

    /**
     * Key {@code FlowDurabilityHint.MAX_SURVIVABILITY.tooltip}: {@code
     * Writes data with every step, using atomic writes for integrity. 
     * Provides maximum ability to retain running pipeline data and resume in
     * the event of a Jenkins failure.}.
     * 
     * @return
     *     {@code Writes data with every step, using atomic writes for integrity.
     *     Provides maximum ability to retain running pipeline data and resume in
     *     the event of a Jenkins failure.}
     */
    public static Localizable _FlowDurabilityHint_MAX_SURVIVABILITY_tooltip() {
        return new Localizable(holder, "FlowDurabilityHint.MAX_SURVIVABILITY.tooltip");
    }

    /**
     * Key {@code FlowDurabilityHint.PERFORMANCE_OPTIMIZED.tooltip}: {@code
     * Avoids writing data with every step, avoids atomic writes of data. 
     * Pipelines can resume if Jenkins shuts down cleanly, but running
     * pipelines lose step information and cannot resume if Jenkins
     * unexpectedly fails.}.
     * 
     * @return
     *     {@code Avoids writing data with every step, avoids atomic writes of
     *     data.  Pipelines can resume if Jenkins shuts down cleanly, but running
     *     pipelines lose step information and cannot resume if Jenkins
     *     unexpectedly fails.}
     */
    public static String FlowDurabilityHint_PERFORMANCE_OPTIMIZED_tooltip() {
        return holder.format("FlowDurabilityHint.PERFORMANCE_OPTIMIZED.tooltip");
    }

    /**
     * Key {@code FlowDurabilityHint.PERFORMANCE_OPTIMIZED.tooltip}: {@code
     * Avoids writing data with every step, avoids atomic writes of data. 
     * Pipelines can resume if Jenkins shuts down cleanly, but running
     * pipelines lose step information and cannot resume if Jenkins
     * unexpectedly fails.}.
     * 
     * @return
     *     {@code Avoids writing data with every step, avoids atomic writes of
     *     data.  Pipelines can resume if Jenkins shuts down cleanly, but running
     *     pipelines lose step information and cannot resume if Jenkins
     *     unexpectedly fails.}
     */
    public static Localizable _FlowDurabilityHint_PERFORMANCE_OPTIMIZED_tooltip() {
        return new Localizable(holder, "FlowDurabilityHint.PERFORMANCE_OPTIMIZED.tooltip");
    }

    /**
     * Key {@code FlowDurabilityHint.SURVIVABLE_NONATOMIC.tooltip}: {@code
     * Writes data with every step but avoids atomic writes. On some
     * filesytems this is faster than maximum durability mode, but running
     * pipeline data may be lost if disk writes are interrupted or fail.}.
     * 
     * @return
     *     {@code Writes data with every step but avoids atomic writes. On some
     *     filesytems this is faster than maximum durability mode, but running
     *     pipeline data may be lost if disk writes are interrupted or fail.}
     */
    public static String FlowDurabilityHint_SURVIVABLE_NONATOMIC_tooltip() {
        return holder.format("FlowDurabilityHint.SURVIVABLE_NONATOMIC.tooltip");
    }

    /**
     * Key {@code FlowDurabilityHint.SURVIVABLE_NONATOMIC.tooltip}: {@code
     * Writes data with every step but avoids atomic writes. On some
     * filesytems this is faster than maximum durability mode, but running
     * pipeline data may be lost if disk writes are interrupted or fail.}.
     * 
     * @return
     *     {@code Writes data with every step but avoids atomic writes. On some
     *     filesytems this is faster than maximum durability mode, but running
     *     pipeline data may be lost if disk writes are interrupted or fail.}
     */
    public static Localizable _FlowDurabilityHint_SURVIVABLE_NONATOMIC_tooltip() {
        return new Localizable(holder, "FlowDurabilityHint.SURVIVABLE_NONATOMIC.tooltip");
    }

}
