/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Action;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FilteratorImpl;

public final class FlowScanningUtils {
    public static final Predicate<FlowNode> MATCH_BLOCK_START = Predicates.instanceOf(BlockStartNode.class);
    public static final Comparator<FlowNode> TIME_ORDER_COMPARATOR = new Comparator<FlowNode>(){

        @Override
        public int compare(@CheckForNull FlowNode first, @CheckForNull FlowNode second) {
            if (first == null && second == null) {
                return 0;
            }
            if (first == null) {
                return 1;
            }
            if (second == null) {
                return -1;
            }
            TimingAction timingFirst = first.getPersistentAction(TimingAction.class);
            TimingAction timingSecond = second.getPersistentAction(TimingAction.class);
            if (timingFirst != null && timingSecond != null) {
                return Long.compare(timingFirst.getStartTime(), timingSecond.getStartTime());
            }
            if (timingFirst == null && timingSecond == null) {
                return 0;
            }
            return timingSecond == null ? -1 : 1;
        }
    };
    public static final Comparator<FlowNode> ID_ORDER_COMPARATOR = new Comparator<FlowNode>(){

        @Override
        public int compare(@CheckForNull FlowNode first, @CheckForNull FlowNode second) {
            if (first == null && second == null) {
                return 0;
            }
            if (first == null) {
                return 1;
            }
            if (second == null) {
                return -1;
            }
            try {
                int id1 = Integer.parseInt(first.getId());
                int id2 = Integer.parseInt(second.getId());
                return Integer.compare(id1, id2);
            }
            catch (NumberFormatException nfe) {
                return first.getId().compareTo(second.getId());
            }
        }
    };

    private FlowScanningUtils() {
    }

    @Nonnull
    public static Predicate<FlowNode> hasActionPredicate(final @Nonnull Class<? extends Action> actionClass) {
        return new Predicate<FlowNode>(){

            public boolean apply(FlowNode input) {
                return input != null && input.getAction(actionClass) != null;
            }
        };
    }

    @Nonnull
    @Deprecated
    public static Filterator<FlowNode> fetchEnclosingBlocks(@Nonnull FlowNode f) {
        return new FilteratorImpl<FlowNode>(f.iterateEnclosingBlocks().iterator(), Predicates.alwaysTrue());
    }
}

