/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.console.AnnotatedLargeText;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.FileLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface LogStorage {
    @Nonnull
    public BuildListener overallListener() throws IOException, InterruptedException;

    @Nonnull
    public TaskListener nodeListener(@Nonnull FlowNode var1) throws IOException, InterruptedException;

    @Nonnull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(@Nonnull FlowExecutionOwner.Executable var1, boolean var2);

    @Nonnull
    public static String startStep(@Nonnull String id) {
        return "<span class=\"pipeline-node-" + id + "\">";
    }

    @Nonnull
    public static String endStep() {
        return "</span>";
    }

    @Nonnull
    public AnnotatedLargeText<FlowNode> stepLog(@Nonnull FlowNode var1, boolean var2);

    @Deprecated
    @Nonnull
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="silly rule")
    default public File getLogFile(@Nonnull FlowExecutionOwner.Executable build, boolean complete) {
        try {
            AnnotatedLargeText<FlowExecutionOwner.Executable> logText = this.overallLog(build, complete);
            FlowExecutionOwner owner = build.asFlowExecutionOwner();
            File f = File.createTempFile("deprecated", ".log", owner != null ? owner.getRootDir() : null);
            f.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(f);){
                long pos2;
                long pos = 0L;
                while ((pos2 = logText.writeRawLogTo(pos, (OutputStream)os)) > pos) {
                    pos = pos2;
                }
            }
            return f;
        }
        catch (Exception x) {
            Logger.getLogger(LogStorage.class.getName()).log(Level.WARNING, null, x);
            if (build instanceof Run) {
                return new File(((Run)build).getRootDir(), "log");
            }
            return new File("broken.log");
        }
    }

    @Nonnull
    public static LogStorage of(@Nonnull FlowExecutionOwner b) {
        try {
            for (LogStorageFactory factory : ExtensionList.lookup(LogStorageFactory.class)) {
                LogStorage storage = factory.forBuild(b);
                if (storage == null) continue;
                return storage;
            }
            return FileLogStorage.forFile(new File(b.getRootDir(), "log"));
        }
        catch (Exception x) {
            return new BrokenLogStorage(x);
        }
    }
}

