/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public abstract class TaskListenerDecorator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TaskListenerDecorator.class.getName());

    @Nonnull
    public abstract OutputStream decorate(@Nonnull OutputStream var1) throws IOException, InterruptedException;

    @Nullable
    public static TaskListenerDecorator merge(@CheckForNull TaskListenerDecorator original, @CheckForNull TaskListenerDecorator subsequent) {
        if (original == null) {
            return subsequent;
        }
        if (subsequent == null) {
            return original;
        }
        return new MergedTaskListenerDecorator(original, subsequent);
    }

    @CheckForNull
    public static TaskListenerDecorator fromConsoleLogFilter(@CheckForNull ConsoleLogFilter filter) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof Serializable) {
            return new ConsoleLogFilterAdapter(filter);
        }
        LOGGER.log(Level.WARNING, "{0} must implement Serializable to be used with Pipeline", filter.getClass());
        return null;
    }

    public static BuildListener apply(@Nonnull TaskListener listener, @Nonnull FlowExecutionOwner owner, @CheckForNull TaskListenerDecorator mainDecorator) {
        JenkinsJVM.checkJenkinsJVM();
        List decorators = Stream.concat(ExtensionList.lookup(Factory.class).stream().map(f -> f.of(owner)), Stream.of(mainDecorator)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (decorators.isEmpty()) {
            return CloseableTaskListener.of(BuildListenerAdapter.wrap((TaskListener)listener), listener);
        }
        Collections.reverse(decorators);
        return CloseableTaskListener.of(new DecoratedTaskListener(listener, decorators), listener);
    }

    private static final class CloseableTaskListener
    implements BuildListener,
    AutoCloseable {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final TaskListener mainDelegate;
        @Nonnull
        private final TaskListener closeDelegate;

        static BuildListener of(BuildListener mainDelegate, TaskListener closeDelegate) {
            if (closeDelegate instanceof AutoCloseable) {
                return new CloseableTaskListener((TaskListener)mainDelegate, closeDelegate);
            }
            return mainDelegate;
        }

        private CloseableTaskListener(TaskListener mainDelegate, TaskListener closeDelegate) {
            this.mainDelegate = mainDelegate;
            this.closeDelegate = closeDelegate;
            assert (closeDelegate instanceof AutoCloseable);
        }

        public PrintStream getLogger() {
            return this.mainDelegate.getLogger();
        }

        @Override
        public void close() throws Exception {
            ((AutoCloseable)this.closeDelegate).close();
        }

        public String toString() {
            return "CloseableTaskListener[" + this.mainDelegate + " / " + this.closeDelegate + "]";
        }
    }

    private static final class DecoratedTaskListener
    implements BuildListener {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final TaskListener delegate;
        @Nonnull
        private final List<TaskListenerDecorator> decorators;
        private transient PrintStream logger;

        DecoratedTaskListener(TaskListener delegate, List<TaskListenerDecorator> decorators) {
            this.delegate = delegate;
            assert (!decorators.isEmpty());
            assert (!decorators.contains(null));
            this.decorators = decorators;
        }

        public PrintStream getLogger() {
            if (this.logger == null) {
                OutputStream base = this.delegate.getLogger();
                for (TaskListenerDecorator decorator : this.decorators) {
                    try {
                        base = decorator.decorate(base);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
                try {
                    this.logger = new PrintStream(base, false, "UTF-8");
                }
                catch (UnsupportedEncodingException x) {
                    throw new AssertionError((Object)x);
                }
            }
            return this.logger;
        }

        public String toString() {
            return "DecoratedTaskListener[" + this.delegate + this.decorators + "]";
        }
    }

    private static class ConsoleLogFilterAdapter
    extends TaskListenerDecorator {
        private static final long serialVersionUID = 1L;
        @Nonnull
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Explicitly checking for serializability.")
        private final ConsoleLogFilter filter;

        ConsoleLogFilterAdapter(ConsoleLogFilter filter) {
            assert (filter instanceof Serializable);
            this.filter = filter;
        }

        @Override
        public OutputStream decorate(OutputStream logger) throws IOException, InterruptedException {
            return this.filter.decorateLogger((AbstractBuild)null, logger);
        }

        public String toString() {
            return "ConsoleLogFilter[" + this.filter + "]";
        }
    }

    private static class MergedTaskListenerDecorator
    extends TaskListenerDecorator {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final TaskListenerDecorator original;
        @Nonnull
        private final TaskListenerDecorator subsequent;

        MergedTaskListenerDecorator(TaskListenerDecorator original, TaskListenerDecorator subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        @Override
        public OutputStream decorate(OutputStream logger) throws IOException, InterruptedException {
            return this.original.decorate(this.subsequent.decorate(logger));
        }

        public String toString() {
            return "MergedTaskListenerDecorator[" + this.subsequent + ", " + this.original + "]";
        }
    }

    public static interface Factory
    extends ExtensionPoint {
        @CheckForNull
        public TaskListenerDecorator of(@Nonnull FlowExecutionOwner var1);
    }
}

