/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import jenkins.plugins.mailer.tasks.MimeMessageBuilder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MailStep
extends AbstractStepImpl {
    private String charset;
    public final String subject;
    public final String body;
    @DataBoundSetter
    public String from;
    @DataBoundSetter
    public String to;
    @DataBoundSetter
    public String cc;
    @DataBoundSetter
    public String bcc;
    @DataBoundSetter
    public String replyTo;
    private String mimeType;

    @DataBoundConstructor
    public MailStep(@Nonnull String subject, @Nonnull String body) {
        this.subject = subject;
        this.body = body;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = Util.fixEmpty((String)charset);
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setMimeType(String mimeType) {
        this.mimeType = Util.fixEmpty((String)mimeType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static class MailStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient MailStep step;
        @StepContextParameter
        private transient TaskListener listener;

        protected Void run() throws Exception {
            MimeMessage mimeMessage = this.buildMimeMessage();
            Transport.send((Message)mimeMessage);
            return null;
        }

        private MimeMessage buildMimeMessage() throws UnsupportedEncodingException, MessagingException, AbortException {
            MimeMessage message;
            Address[] allRecipients;
            if (StringUtils.isBlank((String)this.step.subject) || StringUtils.isBlank((String)this.step.body)) {
                throw new AbortException("Email not sent. All mandatory properties must be supplied ('subject', 'body').");
            }
            MimeMessageBuilder messageBuilder = new MimeMessageBuilder().setListener(this.listener);
            if (this.step.subject != null) {
                messageBuilder.setSubject(this.step.subject);
            }
            if (this.step.body != null) {
                messageBuilder.setBody(this.step.body);
            }
            if (this.step.from != null) {
                messageBuilder.setFrom(this.step.from);
            }
            if (this.step.replyTo != null) {
                messageBuilder.setReplyTo(this.step.replyTo);
            }
            if (this.step.to != null) {
                messageBuilder.addRecipients(this.step.to, Message.RecipientType.TO);
            }
            if (this.step.cc != null) {
                messageBuilder.addRecipients(this.step.cc, Message.RecipientType.CC);
            }
            if (this.step.bcc != null) {
                messageBuilder.addRecipients(this.step.bcc, Message.RecipientType.BCC);
            }
            if (this.step.charset != null) {
                messageBuilder.setCharset(this.step.charset);
            }
            if (this.step.mimeType != null) {
                messageBuilder.setMimeType(this.step.mimeType);
            }
            if ((allRecipients = (message = messageBuilder.buildMimeMessage()).getAllRecipients()) == null || allRecipients.length == 0) {
                throw new AbortException("Email not sent. No recipients of any kind specified ('to', 'cc', 'bcc').");
            }
            return message;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(MailStepExecution.class);
        }

        public String getFunctionName() {
            return "mail";
        }

        public String getDisplayName() {
            return "Mail";
        }
    }
}

