/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.RetryStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class RetryStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private transient RetryStep step;
    private volatile BodyExecution body;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.body = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.step.getCount())).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    private static class Callback
    extends BodyExecutionCallback {
        private int left;
        private static final long serialVersionUID = 1L;

        Callback(int count) {
            this.left = count;
        }

        public void onSuccess(StepContext context, Object result) {
            context.onSuccess(result);
        }

        public void onFailure(StepContext context, Throwable t) {
            try {
                --this.left;
                if (this.left > 0) {
                    TaskListener l = (TaskListener)context.get(TaskListener.class);
                    if (t instanceof AbortException) {
                        l.error(t.getMessage());
                    } else {
                        t.printStackTrace(l.error("Execution failed"));
                    }
                    l.getLogger().println("Retrying");
                    context.newBodyInvoker().withCallback((BodyExecutionCallback)this).start();
                } else {
                    context.onFailure(t);
                }
            }
            catch (Throwable p) {
                context.onFailure(p);
            }
        }
    }
}

