/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class SleepStep
extends AbstractStepImpl {
    private final int time;
    private TimeUnit unit = TimeUnit.SECONDS;

    @DataBoundConstructor
    public SleepStep(int time) {
        this.time = time;
    }

    @DataBoundSetter
    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "sleep";
        }

        public String getDisplayName() {
            return "Sleep";
        }

        public ListBoxModel doFillUnitItems() {
            ListBoxModel r = new ListBoxModel();
            for (TimeUnit unit : TimeUnit.values()) {
                r.add(unit.name());
            }
            return r;
        }
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient SleepStep step;
        @StepContextParameter
        private transient TaskListener listener;
        private long end;
        private volatile transient ScheduledFuture<?> task;

        public boolean start() throws Exception {
            long now = System.currentTimeMillis();
            this.end = now + this.step.unit.toMillis(this.step.time);
            this.setupTimer(now);
            return false;
        }

        private void setupTimer(long now) {
            if (this.end > now) {
                this.listener.getLogger().println("Sleeping for " + Util.getTimeSpanString((long)(this.end - now)));
                this.task = Timer.get().schedule(new Runnable(){

                    @Override
                    public void run() {
                        Execution.this.getContext().onSuccess(null);
                    }
                }, this.end - now, TimeUnit.MILLISECONDS);
            } else {
                this.listener.getLogger().println("No need to sleep any longer");
                this.getContext().onSuccess(null);
            }
        }

        public void stop(Throwable cause) throws Exception {
            if (this.task != null) {
                this.task.cancel(false);
            }
            this.getContext().onFailure(cause);
        }

        public void onResume() {
            super.onResume();
            this.setupTimer(System.currentTimeMillis());
        }

        public String getStatus() {
            long now = System.currentTimeMillis();
            if (this.end > now) {
                return "sleeping for another " + Util.getTimeSpanString((long)(this.end - now));
            }
            return "should have stopped sleeping " + Util.getPastTimeString((long)(now - this.end));
        }
    }
}

