/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class CoreStep
extends Step {
    public final SimpleBuildStep delegate;

    @DataBoundConstructor
    public CoreStep(SimpleBuildStep delegate) {
        this.delegate = delegate;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.delegate, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "step";
        }

        public String getDisplayName() {
            return "General Build Step";
        }

        public boolean isMetaStep() {
            return true;
        }

        public Collection<? extends Descriptor<?>> getApplicableDescriptors() {
            ArrayList r = new ArrayList();
            this.populate(r, Builder.class);
            this.populate(r, Publisher.class);
            return r;
        }

        private <T extends Describable<T>, D extends Descriptor<T>> void populate(List<Descriptor<?>> r, Class<T> c) {
            for (Descriptor d : Jenkins.getActiveInstance().getDescriptorList(c)) {
                if (!SimpleBuildStep.class.isAssignableFrom(d.clazz)) continue;
                r.add(d);
            }
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Map<String, Object> delegateArguments = DescriptorImpl.delegateArguments(namedArgs.get("delegate"));
            return delegateArguments != null ? super.argumentsToString(delegateArguments) : null;
        }

        @CheckForNull
        static Map<String, Object> delegateArguments(@CheckForNull Object delegate) {
            if (delegate instanceof UninstantiatedDescribable) {
                return new HashMap<String, Object>(((UninstantiatedDescribable)delegate).getArguments());
            }
            if (delegate instanceof Map) {
                HashMap<String, Object> r = new HashMap<String, Object>();
                r.putAll((Map)delegate);
                r.remove("$class");
                return r;
            }
            return null;
        }
    }

    private static final class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient SimpleBuildStep delegate;
        private static final long serialVersionUID = 1L;

        Execution(SimpleBuildStep delegate, StepContext context) {
            super(context);
            this.delegate = delegate;
        }

        protected Void run() throws Exception {
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            workspace.mkdirs();
            this.delegate.perform((Run)this.getContext().get(Run.class), workspace, (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }

        public String getStatus() {
            String supe = super.getStatus();
            return this.delegate != null ? this.delegate.getClass().getName() + ": " + supe : supe;
        }
    }
}

