/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class EchoStep
extends Step {
    private final String message;

    @DataBoundConstructor
    public EchoStep(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.message, context);
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String message;
        private static final long serialVersionUID = 1L;

        Execution(String message, StepContext context) {
            super(context);
            this.message = message;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println(this.message);
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "echo";
        }

        public String getDisplayName() {
            return "Print Message";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

